/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.addlemail;

import com.verisign.epp.codec.addlemail.EPPAddlEmail;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import java.util.Date;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPAddlEmailTst {
    private static long numIterations = 1L;

    @Test
    public void testContactCreateASCIIAlternate() {
        EPPCodecTst.printStart("testContactCreateASCIIAlternate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition postalInfo = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-123451", "sh8013", postalInfo, "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("1234");
        theCommand.setFax("+1.7035555556");
        theCommand.addExtension(new EPPAddlEmail("jdoe-alternate@example.com"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactCreateASCIIAlternate");
    }

    @Test
    public void testContactCreateSMTPUTF8Primary() {
        EPPCodecTst.printStart("testContactCreateSMTPUTF8Primary");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition postalInfo = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-123451", "sh8013", postalInfo, "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("1234");
        theCommand.setFax("+1.7035555556");
        theCommand.addExtension(new EPPAddlEmail("\u9ea5\u514b\u98a8@example.com", true));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactCreateSMTPUTF8Primary");
    }

    @Test
    public void testContactUpdateASCIIAlternate() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpdateASCIIAlternate");
        theCommand = new EPPContactUpdateCmd("ABC-123452", "sh8013", null, null, null);
        theCommand.addExtension(new EPPAddlEmail("jdoe-alternate@example.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactUpdateASCIIAlternate");
    }

    @Test
    public void testContactUpdateSMTPUTF8Alternate() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpdateSMTPUTF8Alternate");
        theCommand = new EPPContactUpdateCmd("ABC-123452", "sh8013", null, null, null);
        theCommand.addExtension(new EPPAddlEmail("\u9ea5\u514b\u98a8@example.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactUpdateSMTPUTF8Alternate");
    }

    @Test
    public void testContactUpdateUnsetAlternate() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpdateUnsetAlternate");
        theCommand = new EPPContactUpdateCmd("ABC-123452", "sh8013", null, null, null);
        theCommand.addExtension(new EPPAddlEmail());
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactUpdateUnsetAlternate");
    }

    @Test
    public void testContactInfoRespASCIIAlternate() {
        EPPContactInfoResp theResponse = null;
        EPPEncodeDecodeStats responseStats = null;
        EPPCodecTst.printStart("testContactInfoRespASCIIAlternate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        theResponse = new EPPContactInfoResp(respTransId, "SH8013-REP", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setVoiceExt("1234");
        theResponse.setFax("+1.7035555556");
        EPPContactDisclose disclose = new EPPContactDisclose(true, true, false, true, true, true, true, true, true, true);
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        theResponse.addExtension(new EPPAddlEmail("jdoe-alternate@example.com"));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactInfoRespASCIIAlternate");
    }

    @Test
    public void testContactInfoResponseSMTPUTF8Primary() {
        EPPContactInfoResp theResponse = null;
        EPPEncodeDecodeStats responseStats = null;
        EPPCodecTst.printStart("testContactInfoResponseSMTPUTF8Primary");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        theResponse = new EPPContactInfoResp(respTransId, "SH8013-REP", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setVoiceExt("1234");
        theResponse.setFax("+1.7035555556");
        EPPContactDisclose disclose = new EPPContactDisclose(true, true, false, true, true, true, true, true, true, true);
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        theResponse.addExtension(new EPPAddlEmail("\u9ea5\u514b\u98a8@example.com", true));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactInfoResponseSMTPUTF8Primary");
    }

    @Test
    public void testContactInfoRespUnsetAlternate() {
        EPPContactInfoResp theResponse = null;
        EPPEncodeDecodeStats responseStats = null;
        EPPCodecTst.printStart("testContactInfoRespUnsetAlternate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        theResponse = new EPPContactInfoResp(respTransId, "SH8013-REP", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setVoiceExt("1234");
        theResponse.setFax("+1.7035555556");
        EPPContactDisclose disclose = new EPPContactDisclose(true, true, false, true, true, true, true, true, true, true);
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        theResponse.addExtension(new EPPAddlEmail());
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactInfoRespUnsetAlternate");
    }

    @BeforeClass
    public static void beforeClass() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.addlemail.EPPAddlEmailExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

