/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.addlemail;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPAddlEmail
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "addlEmail";
    public static final String ELM_NAME = "addlEmail:addlEmail";
    private static Logger cat = LoggerFactory.getLogger(EPPAddlEmail.class);
    private static final String ELM_EMAIL = "email";
    private static final String ATTR_PRIMARY = "primary";
    private String email;
    private boolean primary = false;

    public EPPAddlEmail() {
        this.email = null;
    }

    public EPPAddlEmail(String aEmail) {
        this.email = aEmail;
    }

    public EPPAddlEmail(String aEmail, boolean aPrimary) {
        this.email = aEmail;
        this.primary = aPrimary;
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean aPrimary) {
        this.primary = aPrimary;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:addlEmail-1.0", ELM_NAME);
        Element theEmailElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:addlEmail-1.0", "addlEmail:email");
        root.appendChild(theEmailElm);
        if (this.email != null) {
            Text theEmailVal = aDocument.createTextNode(this.email);
            theEmailElm.appendChild(theEmailVal);
        }
        EPPUtil.encodeBooleanAttr(theEmailElm, ATTR_PRIMARY, this.primary);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theEmailElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:addlEmail-1.0", ELM_EMAIL);
        if (theEmailElm == null) {
            throw new EPPDecodeException("addrEmail element must have a child email element");
        }
        this.email = EPPUtil.decodeStringValue(theEmailElm);
        if (this.email != null && this.email.isEmpty()) {
            this.email = null;
        }
        if (theEmailElm.getAttribute(ATTR_PRIMARY) != null) {
            this.primary = EPPUtil.decodeBooleanAttr(theEmailElm, ATTR_PRIMARY);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPAddlEmail clone = (EPPAddlEmail)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPAddlEmail)) {
            return false;
        }
        EPPAddlEmail theComp = (EPPAddlEmail)aObject;
        if (!EqualityUtil.equals(this.email, theComp.email)) {
            cat.error("EPPEAIEmail.equals(): email not equal");
            return false;
        }
        if (this.primary != theComp.primary) {
            cat.error("EPPEAIEmail.equals(): primary not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:addlEmail-1.0";
    }
}

