/*
 * Decompiled with CFR 0.152.
 */
public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static byte[] hexNumberTable;
    private static byte[] lookUpHexAlphabet;

    static boolean isHex(byte octect) {
        return hexNumberTable[octect] != -1;
    }

    static boolean isArrayByteHex(byte[] arrayOctect) {
        if (arrayOctect == null) {
            return false;
        }
        int length = arrayOctect.length;
        if (length % 2 != 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (HexBin.isHex(arrayOctect[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isHex(String isValidString) {
        if (isValidString == null) {
            return false;
        }
        return HexBin.isArrayByteHex(isValidString.getBytes());
    }

    public static byte[] encode(byte[] aBinaryData) {
        if (aBinaryData == null) {
            return null;
        }
        int lengthData = aBinaryData.length;
        int lengthEncode = lengthData * 2;
        byte[] encodedData = new byte[lengthEncode];
        for (int i = 0; i < lengthData; ++i) {
            encodedData[i * 2] = lookUpHexAlphabet[aBinaryData[i] >> 4 & 0xF];
            encodedData[i * 2 + 1] = lookUpHexAlphabet[aBinaryData[i] & 0xF];
        }
        return encodedData;
    }

    public static byte[] decode(byte[] aHexData) {
        if (aHexData == null) {
            return null;
        }
        int lengthData = aHexData.length;
        if (lengthData % 2 != 0) {
            return null;
        }
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        for (int i = 0; i < lengthDecode; ++i) {
            decodedData[i] = (byte)(hexNumberTable[aHexData[i * 2]] << 4 | hexNumberTable[aHexData[i * 2 + 1]]);
        }
        return decodedData;
    }

    public static int getDecodedDataLength(byte[] aHexData) {
        if (!HexBin.isArrayByteHex(aHexData)) {
            return -1;
        }
        return aHexData.length / 2;
    }

    static {
        int i;
        hexNumberTable = new byte[255];
        lookUpHexAlphabet = new byte[16];
        for (i = 0; i < 255; ++i) {
            HexBin.hexNumberTable[i] = -1;
        }
        for (i = 57; i >= 48; --i) {
            HexBin.hexNumberTable[i] = (byte)(i - 48);
        }
        for (i = 70; i >= 65; --i) {
            HexBin.hexNumberTable[i] = (byte)(i - 65 + 10);
        }
        for (i = 102; i >= 97; --i) {
            HexBin.hexNumberTable[i] = (byte)(i - 97 + 10);
        }
        for (i = 0; i < 10; ++i) {
            HexBin.lookUpHexAlphabet[i] = (byte)(48 + i);
        }
        for (i = 10; i <= 15; ++i) {
            HexBin.lookUpHexAlphabet[i] = (byte)(65 + i - 10);
        }
    }
}

