/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.exception.EPPException;
import java.util.StringTokenizer;

public class EPPSSLConfig {
    private String sslProtocol = null;
    private String identityStoreType = null;
    private String identityFileName = null;
    private String identityPassPhrase = null;
    private String identityKeyPassPhrase = null;
    private String trustStoreType = null;
    private String trustStoreFileName = null;
    private String trustStorePassPhrase = null;
    private String sslDebug = null;
    private String[] sslEnabledProtocols = null;
    private String[] sslEnabledCipherSuites = null;
    private boolean sslDisableHostnameVerification = false;

    public EPPSSLConfig() {
    }

    public EPPSSLConfig(String aSslProtocol, String aIdentityStoreType, String aIdentityFileName, String aIdentityPassPhrase) {
        this.sslProtocol = aSslProtocol;
        this.identityStoreType = aIdentityStoreType;
        this.identityFileName = aIdentityFileName;
        this.identityPassPhrase = aIdentityPassPhrase;
    }

    public String getIdentityFileName() {
        return this.identityFileName;
    }

    public void setIdentityFileName(String aIdentityFileName) {
        this.identityFileName = aIdentityFileName;
    }

    public String getIdentityKeyPassPhrase() {
        if (this.identityKeyPassPhrase == null) {
            return this.identityPassPhrase;
        }
        return this.identityKeyPassPhrase;
    }

    public char[] getIdentityKeyPassPhraseCharArray() {
        String theIdentityKeyPassPhrase = this.getIdentityKeyPassPhrase();
        if (theIdentityKeyPassPhrase == null) {
            return null;
        }
        return theIdentityKeyPassPhrase.toCharArray();
    }

    public void setIdentityKeyPassPhrase(String aIdentityKeyPassPhrase) {
        this.identityKeyPassPhrase = aIdentityKeyPassPhrase;
    }

    public String getIdentityPassPhrase() {
        return this.identityPassPhrase;
    }

    public char[] getIdentityPassPhraseCharArray() {
        if (this.identityPassPhrase == null) {
            return null;
        }
        return this.identityPassPhrase.toCharArray();
    }

    public void setIdentityPassPhrase(String aIdentityPassPhrase) {
        this.identityPassPhrase = aIdentityPassPhrase;
    }

    public String getIdentityStoreType() {
        return this.identityStoreType;
    }

    public void setIdentityStoreType(String aIdentityStoreType) {
        this.identityStoreType = aIdentityStoreType;
    }

    public String getSslDebug() {
        return this.sslDebug;
    }

    public void setSslDebug(String aSslDebug) {
        this.sslDebug = aSslDebug;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String aSslProtocol) {
        this.sslProtocol = aSslProtocol;
    }

    public void setTrustStore(String aTrustStoreType, String aTrustStoreFileName, String aTrustStorePassPhrase) {
        this.trustStoreType = aTrustStoreType;
        this.trustStoreFileName = aTrustStoreFileName;
        this.trustStorePassPhrase = aTrustStorePassPhrase;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String aTrustStoreType) {
        this.trustStoreType = aTrustStoreType;
    }

    public String getTrustStoreFileName() {
        return this.trustStoreFileName;
    }

    public void setTrustStoreFileName(String aTrustStoreFileName) {
        this.trustStoreFileName = aTrustStoreFileName;
    }

    public String getTrustStorePassPhrase() {
        return this.trustStorePassPhrase;
    }

    public char[] getTrustStorePassPhraseCharArray() {
        if (this.trustStorePassPhrase == null) {
            return null;
        }
        return this.trustStorePassPhrase.toCharArray();
    }

    public void setTrustStorePassPhrase(String aTrustStorePassPhrase) {
        this.trustStorePassPhrase = aTrustStorePassPhrase;
    }

    public String[] getSSLEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public void setSSLEnabledProtocols(String[] aSslEnabledProtocols) {
        this.sslEnabledProtocols = aSslEnabledProtocols;
    }

    public void setSSLEnabledProtocols(String aSslEnabledProtocols) {
        if (aSslEnabledProtocols != null) {
            StringTokenizer theTokenizer = new StringTokenizer(aSslEnabledProtocols);
            int theNumTokens = theTokenizer.countTokens();
            this.sslEnabledProtocols = new String[theNumTokens];
            for (int i = 0; i < theNumTokens && theTokenizer.hasMoreTokens(); ++i) {
                this.sslEnabledProtocols[i] = theTokenizer.nextToken();
            }
        } else {
            this.sslEnabledProtocols = null;
        }
    }

    public String[] getSSLEnabledCipherSuites() {
        return this.sslEnabledCipherSuites;
    }

    public void setSSLEnabledCipherSuites(String[] aSslEnabledCipherSuites) {
        this.sslEnabledCipherSuites = aSslEnabledCipherSuites;
    }

    public void setSSLEnabledCipherSuites(String aSslEnabledCipherSuites) {
        if (aSslEnabledCipherSuites != null) {
            StringTokenizer theTokenizer = new StringTokenizer(aSslEnabledCipherSuites);
            int theNumTokens = theTokenizer.countTokens();
            this.sslEnabledCipherSuites = new String[theNumTokens];
            for (int i = 0; i < theNumTokens && theTokenizer.hasMoreTokens(); ++i) {
                this.sslEnabledCipherSuites[i] = theTokenizer.nextToken();
            }
        } else {
            this.sslEnabledCipherSuites = null;
        }
    }

    public void validate() throws EPPException {
        if (this.sslProtocol == null) {
            throw new EPPException("EPPSSLConfig: sslProtocol property is required");
        }
        if (this.identityStoreType == null) {
            throw new EPPException("EPPSSLConfig: identityStoreType property is required");
        }
        if (this.identityFileName == null) {
            throw new EPPException("EPPSSLConfig: identityFileName property is required");
        }
        if (this.identityPassPhrase == null) {
            throw new EPPException("EPPSSLConfig: identityPassPhrase property is required");
        }
    }

    public String toString() {
        int i;
        StringBuffer theBuf = new StringBuffer();
        theBuf.append("sslProtocol = " + this.sslProtocol);
        theBuf.append(", identityStoreType = " + this.identityStoreType);
        theBuf.append(", identityFileName = " + this.identityFileName);
        theBuf.append(", trustStoreStoreType = " + this.trustStoreType);
        theBuf.append(", trustStoreFileName = " + this.trustStoreFileName);
        if (this.sslEnabledProtocols != null) {
            theBuf.append(", sslEnabledProtocols = [");
            for (i = 0; i < this.sslEnabledProtocols.length; ++i) {
                if (i != 0) {
                    theBuf.append(" ");
                }
                theBuf.append(this.sslEnabledProtocols[i]);
            }
            theBuf.append("]");
        } else {
            theBuf.append(", sslEnabledProtocols = null");
        }
        if (this.sslEnabledCipherSuites != null) {
            theBuf.append(", sslEnabledCipherSuites = [");
            for (i = 0; i < this.sslEnabledCipherSuites.length; ++i) {
                if (i != 0) {
                    theBuf.append(" ");
                }
                theBuf.append(this.sslEnabledCipherSuites[i]);
            }
            theBuf.append("]");
        } else {
            theBuf.append(", sslEnabledCipherSuites = null");
        }
        theBuf.append(", sslDebug = " + this.sslDebug);
        return theBuf.toString();
    }

    public String[] getSslEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public void setSslEnabledProtocols(String[] aSslEnabledProtocols) {
        this.sslEnabledProtocols = aSslEnabledProtocols;
    }

    public String[] getSslEnabledCipherSuites() {
        return this.sslEnabledCipherSuites;
    }

    public void setSslEnabledCipherSuites(String[] aSslEnabledCipherSuites) {
        this.sslEnabledCipherSuites = aSslEnabledCipherSuites;
    }

    public boolean isSSLDisableHostnameVerification() {
        return this.sslDisableHostnameVerification;
    }

    public void setSSLDisableHostnameVerification(boolean aDisableHostnameVerification) {
        this.sslDisableHostnameVerification = aDisableHostnameVerification;
    }
}

