/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.v1_0;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.codec.ttl.v1_0.EPPTtl;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlCreate;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfData;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfo;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlUpdate;
import com.verisign.epp.codec.ttl.v1_0.RRecType;
import com.verisign.epp.serverstub.TtlSubHostHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtlV1_0HostHandler
implements TtlSubHostHandler {
    private static Logger cat = LoggerFactory.getLogger(TtlV1_0HostHandler.class);

    @Override
    public void doHostInfo(EPPHostInfoCmd aInfoCommand, EPPResponse aResponse, Object aData) {
        cat.info("doHostInfo: Add TTL extension to response");
        if (aInfoCommand.hasExtension(EPPTtlInfo.class)) {
            EPPTtlInfo ttlInfoExt = (EPPTtlInfo)aInfoCommand.getExtension(EPPTtlInfo.class);
            if (ttlInfoExt.isPolicy()) {
                cat.info("doDomainInfo: Add TTL extension with policy attributes to response");
                EPPTtlInfData theInfExt = new EPPTtlInfData();
                theInfExt.addTtl(new EPPTtl(RRecType.A, null, 3600, 172800, 86400, null));
                theInfExt.addTtl(new EPPTtl(RRecType.AAAA, null, 3600, 172800, 86400, 86400));
                aResponse.addExtension(theInfExt);
            } else {
                cat.info("doDomainInfo: Add TTL extension to response");
                EPPTtlInfData theInfExt = new EPPTtlInfData();
                theInfExt.addTtl(new EPPTtl(RRecType.A, 3600));
                theInfExt.addTtl(new EPPTtl(RRecType.AAAA, 86400));
                aResponse.addExtension(theInfExt);
            }
        }
    }

    @Override
    public void doHostCreate(EPPHostCreateCmd aCreateCommand, EPPResponse aResponse, Object aData) {
        cat.info("doHostCreate: TTL create extension = " + (EPPTtlCreate)aCreateCommand.getExtension(EPPTtlCreate.class));
    }

    @Override
    public void doHostUpdate(EPPHostUpdateCmd aUpdateCommand, EPPResponse aResponse, Object aData) {
        cat.info("doHostUpdate: TTL update extension = " + (EPPTtlUpdate)aUpdateCommand.getExtension(EPPTtlUpdate.class));
    }
}

