/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.v1_0;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.ttl.v1_0.EPPTtl;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlCreate;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfData;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfo;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlUpdate;
import com.verisign.epp.codec.ttl.v1_0.RRecType;
import com.verisign.epp.serverstub.TtlSubDomainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtlV1_0DomainHandler
implements TtlSubDomainHandler {
    private static Logger cat = LoggerFactory.getLogger(TtlV1_0DomainHandler.class);

    @Override
    public void doDomainInfo(EPPDomainInfoCmd aInfoCommand, EPPResponse aResponse, Object aData) {
        if (aInfoCommand.hasExtension(EPPTtlInfo.class)) {
            EPPTtlInfo ttlInfoExt = (EPPTtlInfo)aInfoCommand.getExtension(EPPTtlInfo.class);
            if (ttlInfoExt.isPolicy()) {
                cat.info("doDomainInfo: Add TTL extension with policy attributes to response");
                EPPTtlInfData theInfExt = new EPPTtlInfData();
                theInfExt.addTtl(new EPPTtl(RRecType.NS, null, 3600, 172800, 86400, 172800));
                theInfExt.addTtl(new EPPTtl(RRecType.DS, null, 60, 172800, 86400, 300));
                theInfExt.addTtl(new EPPTtl(RRecType.CUSTOM, "DELEG", 3600, 172800, 86400, 300));
                theInfExt.addTtl(new EPPTtl(RRecType.DNAME, null, 3600, 172800, 86400, null));
                aResponse.addExtension(theInfExt);
            } else {
                cat.info("doDomainInfo: Add TTL extension to response");
                EPPTtlInfData theInfExt = new EPPTtlInfData();
                theInfExt.addTtl(new EPPTtl(RRecType.NS, 172800));
                theInfExt.addTtl(new EPPTtl(RRecType.DS, 300));
                theInfExt.addTtl(new EPPTtl(RRecType.CUSTOM, "DELEG", 300));
                aResponse.addExtension(theInfExt);
            }
        }
    }

    @Override
    public void doDomainCreate(EPPDomainCreateCmd aCreateCommand, EPPResponse aResponse, Object aData) {
        cat.info("doDomainCreate: TTL create extension = " + (EPPTtlCreate)aCreateCommand.getExtension(EPPTtlCreate.class));
    }

    @Override
    public void doDomainUpdate(EPPDomainUpdateCmd aUpdateCommand, EPPResponse aResponse, Object aData) {
        cat.info("doDomainUpdate: TTL update extension = " + (EPPTtlUpdate)aUpdateCommand.getExtension(EPPTtlUpdate.class));
    }
}

