/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.registry.policy.EPPRegistryZoneInterface;
import com.verisign.epp.codec.registry.v02.EPPRegistryBatchJob;
import com.verisign.epp.codec.registry.v02.EPPRegistryBatchSchedule;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.v02.EPPRegistryContact;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactName;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.v02.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.v02.EPPRegistryDS;
import com.verisign.epp.codec.registry.v02.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomain;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.v02.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryExceedMaxExDate;
import com.verisign.epp.codec.registry.v02.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.v02.EPPRegistryHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryIDN;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v02.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.v02.EPPRegistryKey;
import com.verisign.epp.codec.registry.v02.EPPRegistryLanguage;
import com.verisign.epp.codec.registry.v02.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.v02.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.v02.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPostal;
import com.verisign.epp.codec.registry.v02.EPPRegistryRGP;
import com.verisign.epp.codec.registry.v02.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v02.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.v02.EPPRegistryServices;
import com.verisign.epp.codec.registry.v02.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.v02.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v02.EPPRegistrySystemInfo;
import com.verisign.epp.codec.registry.v02.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneData;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneList;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneSummary;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.registry.v02.EPPRegistryHandler;
import com.verisign.epp.serverstub.RegistryPolicyCompositeAdapter;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.Environment;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryHandler
extends EPPRegistryHandler {
    private static final String svrTransId = "54322-XYZ";
    private static RegistryZones zones = new RegistryZones();
    private static Logger cat;
    private RegistryPolicyCompositeAdapter registryPolicyAdapter = new RegistryPolicyCompositeAdapter();

    public static RegistryZones getRegistryZones() {
        return zones;
    }

    @Override
    protected EPPEventResponse doRegistryCreate(EPPEvent aEvent, Object aData) {
        cat.debug("doRegistryCreate: enter");
        EPPRegistryCreateCmd message = (EPPRegistryCreateCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        String name = message.getZone().getName().getName();
        Date theCreatedDate = new Date();
        EPPRegistryCreateResp theResponse = new EPPRegistryCreateResp(respTransId, name, theCreatedDate);
        if (zones.zoneExists(name)) {
            EPPResponse theErrResponse = new EPPResponse(respTransId);
            theErrResponse.setResult(2302, "TLD name exists");
            return new EPPEventResponse(theErrResponse);
        }
        try {
            EPPRegistryZone zoneInfo = (EPPRegistryZone)message.getZone().clone();
            zoneInfo.setCreatedBy("test");
            zoneInfo.setCreatedDate(theCreatedDate);
            zoneInfo.setLastUpdatedBy(null);
            zoneInfo.setLastUpdatedDate(null);
            zones.setZone(name, new RegistryZone(zoneInfo));
        }
        catch (CloneNotSupportedException ex) {
            cat.error("Exception caching the created zone: " + ex);
        }
        if (message.hasExtensions()) {
            zones.setZonePolicyExts(name, this.registryPolicyAdapter.eppExtToZoneExt(message.getExtensions()));
        }
        cat.debug("doRegistryCreate: exit");
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doRegistryUpdate(EPPEvent aEvent, Object aData) {
        cat.debug("doRegistryUpdate: enter");
        EPPRegistryUpdateCmd message = (EPPRegistryUpdateCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(respTransId);
        String name = message.getZone().getName().getName();
        if (!zones.zoneExists(name)) {
            theResponse.setResult(2303, "Tld " + message.getZone().getName() + " does not exist. Please create it first");
            cat.debug("doRegistryUpdate: exit");
            return new EPPEventResponse(theResponse);
        }
        theResponse.setResult(1000);
        try {
            RegistryZone theZone = new RegistryZone((EPPRegistryZone)message.getZone().clone());
            theZone.getZoneInfo().setLastUpdatedBy("test");
            theZone.getZoneInfo().setLastUpdatedDate(new Date());
            zones.setZone(name, theZone);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (message.hasExtensions()) {
            zones.setZonePolicyExts(name, this.registryPolicyAdapter.eppExtToZoneExt(message.getExtensions()));
        }
        cat.debug("doRegistryUpdate: exit");
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doRegistryCheck(EPPEvent aEvent, Object aData) {
        EPPRegistryCheckCmd message = (EPPRegistryCheckCmd)aEvent.getMessage();
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        List<EPPRegistryZoneName> names = message.getNames();
        ArrayList<EPPRegistryCheckResult> results = new ArrayList<EPPRegistryCheckResult>();
        for (EPPRegistryZoneName name : names) {
            EPPRegistryCheckResult result;
            if (zones.zoneExists(name.getName())) {
                result = new EPPRegistryCheckResult(name, Boolean.FALSE);
                result.setReason("Already supported");
                results.add(result);
                continue;
            }
            result = new EPPRegistryCheckResult(name, Boolean.TRUE);
            results.add(result);
        }
        EPPRegistryCheckResp theResponse = new EPPRegistryCheckResp(respTransId, results);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doRegistryInfo(EPPEvent aEvent, Object aData) {
        cat.debug("doRegistryInfo ...");
        EPPRegistryInfoCmd message = (EPPRegistryInfoCmd)aEvent.getMessage();
        SessionData theSessionData = (SessionData)aData;
        EPPResponse theResponse = null;
        EPPTransId respTransId = new EPPTransId(message.getTransId(), svrTransId);
        switch (message.getMode()) {
            case name: {
                String name = message.getName().getName();
                RegistryZone zone = zones.getZone(name);
                if (zone != null) {
                    theResponse = new EPPRegistryInfoResp(respTransId, new EPPRegistryZoneData(zone.getZoneInfo(), true));
                    theResponse.setResult(1000);
                } else {
                    cat.warn("zone does not exist: " + message.getName());
                    theResponse = new EPPResponse();
                    theResponse.setResult(2303);
                }
                if (!zone.hasExtensions()) break;
                Vector<EPPService> theExtURIs = theSessionData.getLoginCmd().getExtensionServices();
                List<EPPCodecComponent> theEppExts = this.registryPolicyAdapter.zoneExtToEppExt(zone.getExtensions());
                block5: for (EPPCodecComponent theExt : theEppExts) {
                    for (EPPService theExtURI : theExtURIs) {
                        if (!theExtURI.getNamespaceURI().equals(theExt.getNamespace())) continue;
                        cat.debug("Adding policy EPP extension to response: " + theExtURI);
                        theResponse.addExtension(theExt);
                        continue block5;
                    }
                }
                break;
            }
            case all: {
                EPPRegistryZoneList zoneList = new EPPRegistryZoneList();
                Set<String> theZoneNames = zones.getZoneNames();
                for (String theZoneName : theZoneNames) {
                    RegistryZone theZone = zones.getZone(theZoneName);
                    EPPRegistryZoneSummary theZoneInfo = new EPPRegistryZoneSummary(theZoneName, true, theZone.getZoneInfo().getCreatedDate(), theZone.getZoneInfo().getLastUpdatedDate());
                    zoneList.addZone(theZoneInfo);
                }
                theResponse = new EPPRegistryInfoResp(respTransId, zoneList);
                break;
            }
            case system: {
                EPPRegistrySystemInfo theSystemInfo = new EPPRegistrySystemInfo(200, 600000, 86400000, 10000, 10, 1000);
                theResponse = new EPPRegistryInfoResp(respTransId, theSystemInfo);
                List<EPPCodecComponent> theSystemExts = this.registryPolicyAdapter.getSystemExts();
                if (theSystemExts == null) break;
                for (EPPCodecComponent theSystemExt : theSystemExts) {
                    theResponse.addExtension(theSystemExt);
                }
                break;
            }
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doRegistryDelete(EPPEvent aEvent, Object aData) {
        EPPRegistryDeleteCmd theMessage = (EPPRegistryDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        String name = theMessage.getName().getName();
        if (zones.zoneExists(name)) {
            zones.deleteZone(name);
            theResponse.setResult(1000);
        } else {
            theResponse.setResult(2303, "Requested zone \"" + name + "\" does not exist");
        }
        return new EPPEventResponse(theResponse);
    }

    private static EPPRegistryDomain buildInfoDomain(int aSeq, boolean aDsDataInterface, boolean aHostObjModel) {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(2);
        domainName.setMinLength(5);
        domainName.setMaxLength(50);
        domainName.setAlphaNumStart(true);
        domainName.setAlphaNumEnd(false);
        domainName.setALabelSupported(true);
        domainName.setNameRegex(new EPPRegistryRegex("^[a-zA-Z\\d][a-zA-Z\\d\\-]{4,49}$", "5 to 50 DNS characters starting with alphanumeric"));
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved" + aSeq + "1");
        rNames.add("reserved" + aSeq + "2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(3);
            domainName.getReservedNames().setReservedNames(new ArrayList<String>());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguage("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", EPPRegistryLanguage.VariantStrategy.restricted));
        idn.addLanguage(new EPPRegistryLanguage("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", EPPRegistryLanguage.VariantStrategy.blocked));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(true);
        domain.setContactsSupported(true);
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.admin, 1, 4));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.billing, 2, 5));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.tech, 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        if (aHostObjModel) {
            domain.setChildHostLimit(new EPPRegistryDomainHostLimit((Integer)0, null));
        }
        domain.addPeriod(new EPPRegistryDomainPeriod("create", 1, EPPRegistryPeriodType.Unit.y, 10, EPPRegistryPeriodType.Unit.y, 2, EPPRegistryPeriodType.Unit.y));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, EPPRegistryPeriodType.Unit.y, 10, EPPRegistryPeriodType.Unit.y, 2, EPPRegistryPeriodType.Unit.y));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, EPPRegistryPeriodType.Unit.y, 8, EPPRegistryPeriodType.Unit.y, 2, EPPRegistryPeriodType.Unit.y));
        domain.addExceedMaxExDate(new EPPRegistryExceedMaxExDate(EPPRegistryExceedMaxExDate.Policy.fail, "renew"));
        domain.addExceedMaxExDate(new EPPRegistryExceedMaxExDate(EPPRegistryExceedMaxExDate.Policy.clip, "transfer"));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(1, EPPRegistryPeriodType.Unit.y));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, EPPRegistryPeriodType.Unit.d));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, EPPRegistryPeriodType.Unit.m));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, EPPRegistryPeriodType.Unit.h));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, EPPRegistryPeriodType.Unit.m));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        if (aDsDataInterface) {
            EPPRegistryDS ds = new EPPRegistryDS((Integer)0, (Integer)13);
            ds.addAlgorithm(3);
            ds.addDigestType(1);
            dnssec.setDs(ds);
        } else {
            EPPRegistryKey key = new EPPRegistryKey((Integer)0, (Integer)13);
            key.addFlags(257);
            key.addProtocol(3);
            key.addAlgorithm(3);
            dnssec.setKey(key);
        }
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(12);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        domain.setNullAuthInfoSupported(Boolean.FALSE);
        if (aHostObjModel) {
            domain.setHostModelSupported(EPPRegistryDomain.HostModelSupported.hostObj);
        } else {
            domain.setHostModelSupported(EPPRegistryDomain.HostModelSupported.hostAttr);
        }
        return domain;
    }

    private static EPPRegistryHost buildInfoHost(int aSeq, boolean aHostObjModel) {
        EPPRegistryHost host = new EPPRegistryHost();
        if (aHostObjModel) {
            host.setInternal(new EPPRegistryInternalHost(5, 15, EPPRegistryInternalHost.SharePolicy.perZone, Boolean.FALSE));
            host.setExternal(new EPPRegistryExternalHost(2, 12, EPPRegistryExternalHost.SharePolicy.perZone, Boolean.FALSE));
            host.setMaxCheckHost(15);
            EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
            supportedStatus.addStatus("clientDeleteProhibited");
            supportedStatus.addStatus("serverDeleteProhibited");
            supportedStatus.addStatus("clientUpdateProhibited");
            supportedStatus.addStatus("serverUpdateProhibited");
            supportedStatus.addStatus("linked");
            supportedStatus.addStatus("ok");
            supportedStatus.addStatus("pendingCreate");
            supportedStatus.addStatus("pendingDelete");
            supportedStatus.addStatus("pendingTransfer");
            supportedStatus.addStatus("pendingUpdate");
            host.setSupportedStatus(supportedStatus);
        } else {
            host.setInternal(new EPPRegistryInternalHost(5, 15, null, Boolean.FALSE));
            host.setExternal(new EPPRegistryExternalHost(2, 12, null, Boolean.FALSE));
        }
        host.setNameRegex(new EPPRegistryRegex("^.*$"));
        host.addInvalidIP("http://www.example.com/invalidip-1.txt");
        host.addInvalidIP("http://www.example.com/invalidip-2.txt");
        return host;
    }

    private static EPPRegistryContact buildContact(int aSeq) {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setContactIdPrefix("EX");
        contact.setSharePolicy(EPPRegistryContact.SharePolicy.perZone);
        contact.setIntPostalInfoTypeSupport(EPPRegistryContact.PostalInfoTypeSupport.locOrIntSupport);
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(15);
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setLocCharRegex(new EPPRegistryRegex("^.*$"));
        postalInfo.setName(new EPPRegistryContactName(6, 16));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        new ArrayList();
        postalInfo.setEmailRegex(new EPPRegistryRegex("^.+\\..+$"));
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        contact.setMaxCheckContact(5);
        contact.setPostalInfo(postalInfo);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        return contact;
    }

    static {
        int len = 10;
        String num = Environment.getProperty("Ini.Zone.Count", "10");
        boolean dsDataInterface = true;
        boolean hostObjModel = true;
        if (num != null) {
            len = Integer.parseInt(num);
        }
        for (int i = 0; i < len; ++i) {
            EPPRegistryZone zoneInfo = new EPPRegistryZone("PRESET" + i, "client" + i, new Date());
            zoneInfo.setLastUpdatedBy("client" + i);
            zoneInfo.setLastUpdatedDate(new Date());
            zoneInfo.setUnsupportedData(EPPRegistryZone.UnsupportedData.fail);
            EPPRegistryBatchJob batchJob = new EPPRegistryBatchJob("localTzBatch", "Batch with multiple local time schedules (name and offset)");
            batchJob.addSchedule(new EPPRegistryBatchSchedule("04:00:00", "EST5EDT"));
            batchJob.addSchedule(new EPPRegistryBatchSchedule("07:00:00-05:00", null));
            zoneInfo.addBatchJob(batchJob);
            batchJob = new EPPRegistryBatchJob("multiBatchSchedule", "Batch with multiple UTC schedules");
            batchJob.addSchedule(new EPPRegistryBatchSchedule("12:00:00Z", null));
            batchJob.addSchedule(new EPPRegistryBatchSchedule("12:00:00Z", EPPRegistryBatchSchedule.DayOfWeek.SUNDAY, null));
            batchJob.addSchedule(new EPPRegistryBatchSchedule("17:00:00Z", 15, null));
            zoneInfo.addBatchJob(batchJob);
            zoneInfo.setGroup("g" + i);
            EPPRegistryServices services = new EPPRegistryServices();
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/rgp-poll-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:host-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:contact-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:domain-1.0", Boolean.TRUE));
            services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/lowbalance-poll-1.0", Boolean.FALSE));
            EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
            services.setExtension(svcExt);
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign-grs.com/epp/namestoreExt-1.1", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:rgp-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/sync-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/idnLang-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/premiumdomain-1.0", Boolean.TRUE));
            svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:secDNS-1.1", Boolean.FALSE));
            zoneInfo.setServices(services);
            zoneInfo.setCreatedBy("crId");
            zoneInfo.setCreatedDate(new Date());
            zoneInfo.setLastUpdatedBy("upId");
            zoneInfo.setLastUpdatedDate(new Date());
            zoneInfo.setDomain(RegistryHandler.buildInfoDomain(i, dsDataInterface, hostObjModel));
            dsDataInterface = !dsDataInterface;
            zoneInfo.setHost(RegistryHandler.buildInfoHost(i, hostObjModel));
            hostObjModel = !hostObjModel;
            zoneInfo.setContact(RegistryHandler.buildContact(i));
            zones.setZone(zoneInfo.getName().getName(), new RegistryZone(zoneInfo));
        }
        cat = LoggerFactory.getLogger(RegistryHandler.class);
    }

    public static class RegistryZone {
        private EPPRegistryZone zoneInfo;
        private List<EPPRegistryZoneInterface> extensions;

        public RegistryZone() {
        }

        public RegistryZone(EPPRegistryZone aZoneInfo) {
            this.zoneInfo = aZoneInfo;
        }

        public RegistryZone(EPPRegistryZone aZoneInfo, List<EPPRegistryZoneInterface> aExtensions) {
            this.zoneInfo = aZoneInfo;
            this.extensions = aExtensions;
        }

        public boolean hasZoneInfo() {
            return this.zoneInfo != null;
        }

        public EPPRegistryZone getZoneInfo() {
            return this.zoneInfo;
        }

        public void setZoneInfo(EPPRegistryZone aZoneInfo) {
            this.zoneInfo = aZoneInfo;
        }

        public boolean hasExtensions() {
            return this.extensions != null && !this.extensions.isEmpty();
        }

        public List<EPPRegistryZoneInterface> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<EPPRegistryZoneInterface> aExtensions) {
            this.extensions = aExtensions;
        }

        public void setExtension(EPPRegistryZoneInterface aExtension) {
            if (aExtension == null) {
                return;
            }
            if (this.extensions == null) {
                this.addExtension(aExtension);
            }
            Iterator<EPPRegistryZoneInterface> theIter = this.extensions.iterator();
            boolean replaced = false;
            while (theIter.hasNext()) {
                EPPRegistryZoneInterface theExt = theIter.next();
                if (!theExt.getClass().isInstance(aExtension.getClass())) continue;
                theIter.remove();
                this.extensions.add(theExt);
                replaced = true;
                break;
            }
            if (!replaced) {
                this.extensions.add(aExtension);
            }
        }

        public EPPRegistryZoneInterface getExtension(Class aExtClass) {
            if (this.extensions == null) {
                return null;
            }
            for (EPPRegistryZoneInterface theExtension : this.extensions) {
                if (!aExtClass.isInstance(theExtension)) continue;
                return theExtension;
            }
            return null;
        }

        public void addExtension(EPPRegistryZoneInterface aExtension) {
            if (aExtension == null) {
                return;
            }
            if (this.extensions == null) {
                this.extensions = new ArrayList<EPPRegistryZoneInterface>();
            }
            this.extensions.add(aExtension);
        }

        public String toString() {
            Object ret = this.zoneInfo.toString();
            for (EPPRegistryZoneInterface ext : this.extensions) {
                ret = (String)ret + "\n" + ext;
            }
            return ret;
        }
    }

    public static class RegistryZones {
        Map<String, RegistryZone> zones = new HashMap<String, RegistryZone>();

        public boolean zoneExists(String aName) {
            return this.zones.containsKey(aName = aName.toUpperCase());
        }

        public Set<String> getZoneNames() {
            if (this.zones != null) {
                return this.zones.keySet();
            }
            return null;
        }

        public RegistryZone getZone(String aName) {
            aName = aName.toUpperCase();
            return this.zones.get(aName);
        }

        public void setZone(String aName, RegistryZone aZone) {
            aName = aName.toUpperCase();
            this.zones.put(aName, aZone);
        }

        public boolean setZoneInfo(String aName, EPPRegistryZone aZoneInfo) {
            aName = aName.toUpperCase();
            boolean theZoneInfoSet = false;
            RegistryZone theZone = this.zones.get(aName);
            if (theZone != null) {
                theZone.setZoneInfo(aZoneInfo);
                theZoneInfoSet = true;
            }
            return theZoneInfoSet;
        }

        public void setZonePolicyExt(String aName, EPPRegistryZoneInterface aZonePolicy) {
            aName = aName.toUpperCase();
            RegistryZone theZone = this.zones.get(aName);
            theZone.setExtension(aZonePolicy);
        }

        public void setZonePolicyExts(String aName, List<EPPRegistryZoneInterface> aZonePolicies) {
            aName = aName.toUpperCase();
            RegistryZone theZone = this.zones.get(aName);
            theZone.setExtensions(aZonePolicies);
        }

        public void deleteZone(String aName) {
            aName = aName.toUpperCase();
            this.zones.remove(aName);
        }
    }
}

