/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.addlemail;

import com.verisign.epp.codec.addlemail.EPPAddlEmail;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.ContactHandler;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddlEmailContactHandler
extends ContactHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = LoggerFactory.getLogger(AddlEmailContactHandler.class);

    @Override
    public EPPEventResponse doContactCreate(EPPEvent aEvent, Object aData) {
        EPPContactCreateCmd theCommand = (EPPContactCreateCmd)aEvent.getMessage();
        if (theCommand.getId().startsWith("AE-")) {
            if (theCommand.getId().equals("AE-1")) {
                EPPAddlEmail theAddlEmailIExt;
                if (theCommand.hasEmail() && !Charset.forName("US-ASCII").newEncoder().canEncode(theCommand.getEmail())) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("Contact email must be ASCII");
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
                if (!(!theCommand.hasExtension(EPPAddlEmail.class) || (theAddlEmailIExt = (EPPAddlEmail)theCommand.getExtension(EPPAddlEmail.class)).hasEmail() && Charset.forName("US-ASCII").newEncoder().canEncode(theAddlEmailIExt.getEmail()))) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("Expected ASCII alternate email for contact id = " + theCommand.getId());
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
            } else if (theCommand.getId().equals("AE-2")) {
                EPPAddlEmail theAddlEmailIExt;
                if (theCommand.hasEmail() && !Charset.forName("US-ASCII").newEncoder().canEncode(theCommand.getEmail())) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("Contact email must be ASCII");
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
                if (theCommand.hasExtension(EPPAddlEmail.class) && (!(theAddlEmailIExt = (EPPAddlEmail)theCommand.getExtension(EPPAddlEmail.class)).hasEmail() || Charset.forName("US-ASCII").newEncoder().canEncode(theAddlEmailIExt.getEmail()))) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("Expected SMPTUTF8 alternate email for contact id = " + theCommand.getId());
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
            }
        }
        return super.doContactCreate(aEvent, aData);
    }

    @Override
    public EPPEventResponse doContactUpdate(EPPEvent aEvent, Object aData) {
        EPPContactUpdateCmd theCommand = (EPPContactUpdateCmd)aEvent.getMessage();
        if (theCommand.getId().startsWith("AE-")) {
            EPPAddlEmail theAddlEmailIExt;
            if (theCommand.getId().equals("AE-1")) {
                EPPAddlEmail theAddlEmailIExt2;
                if (!(!theCommand.hasExtension(EPPAddlEmail.class) || (theAddlEmailIExt2 = (EPPAddlEmail)theCommand.getExtension(EPPAddlEmail.class)).hasEmail() && Charset.forName("US-ASCII").newEncoder().canEncode(theAddlEmailIExt2.getEmail()))) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("Expected ASCII alternate email for contact id = " + theCommand.getId());
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
            } else if (theCommand.getId().equals("AE-2")) {
                EPPAddlEmail theAddlEmailIExt3;
                if (theCommand.hasExtension(EPPAddlEmail.class) && (!(theAddlEmailIExt3 = (EPPAddlEmail)theCommand.getExtension(EPPAddlEmail.class)).hasEmail() || Charset.forName("US-ASCII").newEncoder().canEncode(theAddlEmailIExt3.getEmail()))) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                    EPPResponse theResponse = new EPPResponse(transId);
                    EPPResult theResult = new EPPResult(2308);
                    theResult.addExtValueReason("Expected SMPTUTF8 alternate email for contact id = " + theCommand.getId());
                    theResponse.setResult(theResult);
                    return new EPPEventResponse(theResponse);
                }
            } else if (theCommand.getId().equals("AE-3") && theCommand.hasExtension(EPPAddlEmail.class) && (theAddlEmailIExt = (EPPAddlEmail)theCommand.getExtension(EPPAddlEmail.class)).hasEmail()) {
                EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
                EPPResponse theResponse = new EPPResponse(transId);
                EPPResult theResult = new EPPResult(2308);
                theResult.addExtValueReason("Expecting empty alternate email for contact id = " + theCommand.getId());
                theResponse.setResult(theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        return super.doContactUpdate(aEvent, aData);
    }

    @Override
    public EPPEventResponse doContactInfo(EPPEvent aEvent, Object aData) {
        EPPContactInfoCmd theCommand = (EPPContactInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doContactInfo(aEvent, aData);
        EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
        if (theCommand.getId().startsWith("AE-")) {
            if (theCommand.getId().equals("AE-1")) {
                if (theResponse instanceof EPPContactInfoResp) {
                    theResponse.addExtension(new EPPAddlEmail("jdoe-alternate@example.com"));
                }
            } else if (theCommand.getId().equals("AE-2")) {
                if (theResponse instanceof EPPContactInfoResp) {
                    theResponse.addExtension(new EPPAddlEmail("\u9ea5\u514b\u98a8@example.com", true));
                }
            } else if (theCommand.getId().equals("AE-3") && theResponse instanceof EPPContactInfoResp) {
                theResponse.addExtension(new EPPAddlEmail());
            }
        }
        return theEventResponse;
    }

    private boolean supportsNamespace(String aNamespace, List<EPPService> aServices) {
        cat.debug("supportsNamespace(String, List); Looking for namespace " + aNamespace + " support");
        if (aServices != null) {
            for (EPPService theService : aServices) {
                if (!theService.getNamespaceURI().equals(aNamespace)) continue;
                cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " supported");
                return true;
            }
        }
        cat.debug("supportsNamespace(String, List); namespace " + aNamespace + " not supported");
        return false;
    }
}

