/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlCreate;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlUpdate;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.HostHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.serverstub.v1_0.TtlV1_0HostHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtlHostHandler
extends HostHandler {
    private static Logger cat = LoggerFactory.getLogger(TtlHostHandler.class);
    TtlV1_0HostHandler v1_0SubHandler = new TtlV1_0HostHandler();

    @Override
    protected EPPEventResponse doHostInfo(EPPEvent aEvent, Object aData) {
        SessionData theSessionData = (SessionData)aData;
        EPPHostInfoCmd theCommand = (EPPHostInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doHostInfo(aEvent, aData);
        if (theSessionData.getLoginCmd().hasExtensionService("urn:ietf:params:xml:ns:epp:ttl-1.0")) {
            this.v1_0SubHandler.doHostInfo(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doHostCreate(EPPEvent aEvent, Object aData) {
        EPPHostCreateCmd theCommand = (EPPHostCreateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doHostCreate(aEvent, aData);
        if (theCommand.hasExtension(EPPTtlCreate.class)) {
            this.v1_0SubHandler.doHostCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info("doHostCreate: TTL create = null");
            System.out.println("doHostCreate: TTL create = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doHostUpdate(EPPEvent aEvent, Object aData) {
        EPPHostUpdateCmd theCommand = (EPPHostUpdateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doHostUpdate(aEvent, aData);
        if (theCommand.hasExtension(EPPTtlUpdate.class)) {
            this.v1_0SubHandler.doHostUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info("doHostUpdate: TTL update = null");
            System.out.println("doHostUpdate: TTL update = null");
        }
        return theEventResponse;
    }
}

