/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlCreate;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlUpdate;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.serverstub.v1_0.TtlV1_0DomainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtlDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(TtlDomainHandler.class);
    TtlV1_0DomainHandler v1_0SubHandler = new TtlV1_0DomainHandler();

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        SessionData theSessionData = (SessionData)aData;
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        if (theSessionData.getLoginCmd().hasExtensionService("urn:ietf:params:xml:ns:epp:ttl-1.0")) {
            this.v1_0SubHandler.doDomainInfo(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        if (theCommand.hasExtension(EPPTtlCreate.class)) {
            this.v1_0SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info("doDomainCreate: TTL create = null");
            System.out.println("doDomainCreate: TTL create = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        if (theCommand.hasExtension(EPPTtlUpdate.class)) {
            this.v1_0SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info("doDomainUpdate: TTL update = null");
            System.out.println("doDomainUpdate: TTL update = null");
        }
        return theEventResponse;
    }
}

