/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.framework.EPPAssembler;
import com.verisign.epp.framework.EPPDispatcher;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.framework.EPPXMLAssembler;
import com.verisign.epp.serverstub.ClientConnectionHandler;
import com.verisign.epp.serverstub.ConnectionHandler;
import com.verisign.epp.serverstub.PollDataSource;
import com.verisign.epp.transport.EPPServerCon;
import com.verisign.epp.transport.EPPSrvFactorySingle;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    public static final int WK_PORT = 2015;
    private static Logger cat = LoggerFactory.getLogger(Server.class);

    public Server(String configFileName) {
        try {
            EPPEnvSingle env = EPPEnvSingle.getInstance();
            env.initialize(configFileName);
            this.initializeDispatcher();
            EPPPollQueueMgr.getInstance().setDataSource(new PollDataSource());
            this.initializePollQueue();
        }
        catch (EPPEnvException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void initializePollQueue() {
        EPPPollQueueMgr thePollQueue = EPPPollQueueMgr.getInstance();
        try {
            Vector<String> handlerClasses = EPPEnv.getPollHandlers();
            if (handlerClasses != null) {
                Enumeration<String> e = handlerClasses.elements();
                while (e.hasMoreElements()) {
                    String handlerClassName = e.nextElement();
                    Class<?> handlerClass = Class.forName(handlerClassName);
                    thePollQueue.register((EPPPollHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    cat.info("Successfully loaded poll handler: " + handlerClass.getName());
                }
            }
        }
        catch (Exception e) {
            cat.error("EPP Server couldn't initialize the environment:" + e);
            System.exit(1);
        }
    }

    public void initializeDispatcher() {
        EPPDispatcher theDispatcher = EPPDispatcher.getInstance();
        try {
            Vector<String> theMapFactories;
            EPPFactory theFactory = EPPFactory.getInstance();
            Vector<String> commandExts = EPPEnv.getCmdResponseExtensions();
            if (commandExts != null && commandExts.elements().hasMoreElements()) {
                for (int i = 0; i < commandExts.size(); ++i) {
                    String commandExtensionClassName = commandExts.elementAt(i);
                    try {
                        theFactory.addExtFactory(commandExtensionClassName);
                    }
                    catch (EPPCodecException ex) {
                        cat.error("Couldn't load the Extension Factoryassociated with the CommandResponseExtensions" + ex);
                        System.exit(1);
                    }
                    cat.info("Successfully loaded Command Extension Class:" + commandExtensionClassName);
                }
            }
            if ((theMapFactories = EPPEnv.getMapFactories()) != null && theMapFactories.elements().hasMoreElements()) {
                for (int i = 0; i < theMapFactories.size(); ++i) {
                    String mapFactoryClassName = theMapFactories.elementAt(i);
                    try {
                        theFactory.addMapFactory(mapFactoryClassName);
                    }
                    catch (EPPCodecException ex) {
                        cat.error("Couldn't load the Map Factory " + mapFactoryClassName + ":" + ex);
                        System.exit(1);
                    }
                    cat.info("Successfully loaded Map Factory Class:" + mapFactoryClassName);
                }
            }
            Vector<String> theServerEventHandlers = EPPEnv.getServerEventHandlers();
            Enumeration<String> e = theServerEventHandlers.elements();
            while (e.hasMoreElements()) {
                String handlerClassName = e.nextElement();
                Class<?> handlerClass = Class.forName(handlerClassName);
                theDispatcher.registerHandler((EPPEventHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                cat.info("Successfully loaded server handler: " + handlerClass.getName());
            }
        }
        catch (EPPEnvException e) {
            cat.error("Couldn't initialize the environment", (Throwable)e);
            System.exit(1);
        }
        catch (InstantiationException e) {
            cat.error("Couldn't instantiate one of the specified server event handlers:", (Throwable)e);
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            cat.error("Couldn't instantiate one of the specified server event handlers\n The class or initializer is not accessible:", (Throwable)e);
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            cat.error("Couldn't instantiate one of the event handlers listed in the conf file:", (Throwable)e);
            System.exit(1);
        }
        catch (Exception e) {
            cat.error("General exception in initializeDispatcher: ", (Throwable)e);
            System.exit(1);
        }
        try {
            String assemblerClassName = EPPEnv.getServerEPPAssembler();
            if (assemblerClassName != null && assemblerClassName.length() > 0) {
                cat.info("Found Assembler class in config: [" + assemblerClassName + "]");
                cat.info("Attempting to instantiate " + assemblerClassName + "...");
                Class<?> assemblerClass = Class.forName(assemblerClassName);
                EPPAssembler assembler = (EPPAssembler)assemblerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                theDispatcher.setAssembler(assembler);
                cat.info("Successfully set assembler " + assemblerClassName);
            } else {
                cat.info("No EPPServerAssembler specified. Using default... (com.verisign.epp.framework.EPPXMLAssembler)");
                theDispatcher.setAssembler(new EPPXMLAssembler());
            }
        }
        catch (Exception e) {
            cat.error("EPP Server Initialization Exception: " + e);
            System.exit(1);
        }
        theDispatcher.registerConnectionHandler(new ConnectionHandler());
    }

    private void run() {
        EPPSrvFactorySingle theFactory = EPPSrvFactorySingle.getInstance();
        cat.info("EPP Server: Starting server...");
        try {
            EPPServerCon theServer = theFactory.getEPPServer();
            theServer.RunServer(new ClientConnectionHandler());
        }
        catch (Exception e) {
            cat.error("EPP Server: Run Exception: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        String theConfigFile = "epp.config";
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("-help")) {
                System.out.println("Usage: java Server [-help|<config-file>]");
                System.out.println("Executes the EPP over TCP (EoT) Stub Server");
                System.out.println("\t-help gets this help");
                System.out.println("\t<config-file> EPP SDK configuration settings, with default of \"epp.config\"");
                System.exit(0);
            }
            theConfigFile = args[0];
        } else if (args.length > 1) {
            System.out.println("Usage: java Server [-help|<config-file>]");
            System.out.println("Executes the EPP over TCP (EoT) Stub Server");
            System.out.println("\t-help gets this help");
            System.out.println("\t<config-file> EPP SDK configuration settings, with default of \"epp.config\"");
            System.exit(1);
        }
        Server theServer = new Server(theConfigFile);
        theServer.run();
    }
}

