/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollResponse;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollThreshold;
import com.verisign.epp.codec.persreg.EPPPersRegCreateData;
import com.verisign.epp.codec.persreg.EPPPersRegCreateErrData;
import com.verisign.epp.codec.persreg.EPPPersRegInfoData;
import com.verisign.epp.codec.persreg.EPPPersRegRenewData;
import com.verisign.epp.codec.persreg.EPPPersRegTransferData;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersRegDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(PersRegDomainHandler.class);

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPEventResponse theResponse = super.doDomainRenew(aEvent, aData);
        ((EPPResponse)theResponse.getResponse()).addExtension(new EPPPersRegRenewData(true));
        return theResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPEventResponse theResponse = super.doDomainCreate(aEvent, aData);
        EPPDomainCreateCmd theMessage = (EPPDomainCreateCmd)aEvent.getMessage();
        if (theMessage.getName().indexOf("error") != -1) {
            ((EPPResponse)theResponse.getResponse()).setResult(2305);
            ((EPPResponse)theResponse.getResponse()).addExtension(new EPPPersRegCreateErrData(2));
        } else if (theMessage.getName().equalsIgnoreCase("test.com")) {
            EPPLowBalancePollResponse thePollMsg = new EPPLowBalancePollResponse();
            thePollMsg.setRegistrarName("Test Registar");
            thePollMsg.setCreditLimit("1000");
            thePollMsg.setCreditThreshold(new EPPLowBalancePollThreshold("PERCENT", "10"));
            thePollMsg.setAvailableCredit("80");
            try {
                EPPPollQueueMgr.getInstance().put(null, "http://www.verisign.com/epp/lowbalance-poll-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainCreate: Error putting message [" + thePollMsg + "]");
                EPPResult theResult = new EPPResult(2400);
                ((EPPResponse)theResponse.getResponse()).setResult(theResult);
            }
        } else {
            ((EPPResponse)theResponse.getResponse()).addExtension(new EPPPersRegCreateData(true));
        }
        return theResponse;
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPEventResponse theResponse = super.doDomainTransfer(aEvent, aData);
        EPPDomainTransferCmd theMessage = (EPPDomainTransferCmd)aEvent.getMessage();
        if (theMessage.getOp().equals("request")) {
            ((EPPResponse)theResponse.getResponse()).addExtension(new EPPPersRegTransferData(true));
        }
        return theResponse;
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPEventResponse theResponse = super.doDomainInfo(aEvent, aData);
        ((EPPResponse)theResponse.getResponse()).addExtension(new EPPPersRegInfoData("ID:12345"));
        return theResponse;
    }
}

