/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.framework.EPPByteArrayDispatcher;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.framework.HttpEPPXMLAssembler;
import com.verisign.epp.serverstub.ControllerServlet;
import com.verisign.epp.serverstub.PollDataSource;
import com.verisign.epp.transport.EPPSrvFactorySingle;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static Logger cat = LoggerFactory.getLogger(HttpServer.class);

    public HttpServer(String aConfigFile) {
        try {
            EPPEnvSingle env = EPPEnvSingle.getInstance();
            env.initialize(aConfigFile);
            EPPSrvFactorySingle.getInstance();
            this.initializeDispatcher();
            EPPPollQueueMgr.getInstance().setDataSource(new PollDataSource());
            this.initializePollQueue();
        }
        catch (EPPEnvException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initializePollQueue() {
        cat.debug("initializePollQueue: enter");
        EPPPollQueueMgr thePollQueue = EPPPollQueueMgr.getInstance();
        try {
            Vector<String> handlerClasses = EPPEnv.getPollHandlers();
            if (handlerClasses != null) {
                for (String handlerClassName : handlerClasses) {
                    cat.debug("initializePollQueue: Loading poll handler " + handlerClassName);
                    Class<?> handlerClass = Class.forName(handlerClassName);
                    thePollQueue.register((EPPPollHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    cat.info("initializePollQueue: Successfully loaded poll handler " + handlerClass.getName());
                }
            }
        }
        catch (Exception e) {
            cat.error("EoR Server: Exception initalizing the poll queue:" + e);
            e.printStackTrace();
            System.exit(1);
        }
        cat.debug("initializePollQueue: exit");
    }

    public void initializeDispatcher() {
        EPPByteArrayDispatcher theDispatcher = EPPByteArrayDispatcher.getInstance();
        try {
            Vector<String> handlerClasses = EPPEnv.getServerEventHandlers();
            Enumeration<String> e = handlerClasses.elements();
            while (e.hasMoreElements()) {
                String handlerClassName = e.nextElement();
                Class<?> handlerClass = Class.forName(handlerClassName);
                theDispatcher.registerHandler((EPPEventHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                cat.info("Successfully loaded server handler: " + handlerClass.getName());
            }
            EPPFactory factory = EPPFactory.getInstance();
            Vector<String> commandExts = EPPEnv.getCmdResponseExtensions();
            if (commandExts != null && commandExts.elements().hasMoreElements()) {
                for (int i = 0; i < commandExts.size(); ++i) {
                    String commandExtensionClassName = commandExts.elementAt(i);
                    try {
                        factory.addExtFactory(commandExtensionClassName);
                    }
                    catch (EPPCodecException ex) {
                        cat.error("Couldn't load the Extension Factory associated with the CommandResponseExtensions" + ex);
                        ex.printStackTrace();
                    }
                    cat.info("Successfully loaded Command Extension Class:" + commandExtensionClassName);
                }
            }
            theDispatcher.setAssembler(new HttpEPPXMLAssembler());
        }
        catch (Exception e) {
            cat.error("EoH Server: Exception initalizing the dispatcher:" + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() {
        EPPSrvFactorySingle theFactory = EPPSrvFactorySingle.getInstance();
        cat.info("EoH Server: Starting server...");
        try {
            Tomcat theHttpServer = new Tomcat();
            theHttpServer.setBaseDir(new File(".").getAbsolutePath());
            Connector theConnector = new Connector();
            theConnector.setPort(EPPEnv.getServerPort());
            cat.debug("Server Port = " + EPPEnv.getServerPort());
            theConnector.setScheme(EPPEnv.getHttpServerScheme());
            cat.debug("Server HTTP Protocol = " + EPPEnv.getHttpServerScheme());
            if (EPPEnv.getHttpServerScheme().equalsIgnoreCase("https")) {
                cat.debug("Initializing HTTPS");
                System.setProperty("javax.net.debug", EPPEnv.getSSLDebug());
                theConnector.setProperty("SSLEnabled", "true");
                theConnector.setProperty("clientAuth", "true");
                theConnector.setSecure(true);
                SSLHostConfig theSslHostConfig = new SSLHostConfig();
                theSslHostConfig.setSslProtocol(EPPEnv.getSSLProtocol());
                theSslHostConfig.setEnabledCiphers(EPPEnv.getSSLEnabledCipherSuites());
                theSslHostConfig.setEnabledProtocols(EPPEnv.getSSLEnabledProtocols());
                theSslHostConfig.setTruststoreFile(EPPEnv.getSSLTrustStoreFileName());
                theSslHostConfig.setTruststorePassword(EPPEnv.getSSLTrustStorePassPhrase());
                theSslHostConfig.setTruststoreType(EPPEnv.getKeyStore());
                theSslHostConfig.setCertificateVerification("true");
                theSslHostConfig.setHostName("_default_");
                SSLHostConfigCertificate theSslHostConfigCertificate = new SSLHostConfigCertificate(theSslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
                theSslHostConfigCertificate.setCertificateKeystoreFile(EPPEnv.getSSLKeyFileName());
                theSslHostConfigCertificate.setCertificateKeystorePassword(EPPEnv.getSSLPassPhrase());
                theSslHostConfigCertificate.setCertificateKeystoreType(EPPEnv.getKeyStore());
                theSslHostConfigCertificate.setCertificateKeyPassword(EPPEnv.getSSLKeyPassPhrase());
                theSslHostConfig.addCertificate(theSslHostConfigCertificate);
                theConnector.addSslHostConfig(theSslHostConfig);
            } else {
                theConnector.setSecure(false);
            }
            Http2Protocol http2Protocol = new Http2Protocol();
            theConnector.getProtocolHandler().addUpgradeProtocol((UpgradeProtocol)http2Protocol);
            String theContextPath = "";
            String theDocBase = new File(".").getAbsolutePath();
            Context theContext = theHttpServer.addContext(theContextPath, theDocBase);
            theHttpServer.addServlet(theContextPath, "EoHControllerServlet", ControllerServlet.class.getName());
            theContext.addServletMappingDecoded("/", "EoHControllerServlet");
            theHttpServer.start();
            theHttpServer.getService().addConnector(theConnector);
            theHttpServer.getServer().await();
        }
        catch (Exception e) {
            cat.error("EoH Server: Run Exception: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        String theConfigFile = "epp.config";
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("-help")) {
                System.out.println("Usage: java Server [-help|<config-file>]");
                System.out.println("Executes the EPP over HTTP (EoH) Stub Server");
                System.out.println("\t-help gets this help");
                System.out.println("\t<config-file> EPP SDK configuration settings, with default of \"epp.config\"");
                System.exit(0);
            }
            theConfigFile = args[0];
        } else if (args.length > 1) {
            System.out.println("Usage: java Server [-help|<config-file>]");
            System.out.println("Executes the EPP over HTTP (EoH) Stub Server");
            System.out.println("\t-help gets this help");
            System.out.println("\t<config-file> EPP SDK configuration settings, with default of \"epp.config\"");
            System.exit(1);
        }
        HttpServer theServer = new HttpServer(theConfigFile);
        theServer.run();
    }
}

