/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.defReg.EPPDefRegCheckCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCheckResp;
import com.verisign.epp.codec.defReg.EPPDefRegCheckResult;
import com.verisign.epp.codec.defReg.EPPDefRegCreateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCreateResp;
import com.verisign.epp.codec.defReg.EPPDefRegDeleteCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoResp;
import com.verisign.epp.codec.defReg.EPPDefRegName;
import com.verisign.epp.codec.defReg.EPPDefRegRenewCmd;
import com.verisign.epp.codec.defReg.EPPDefRegRenewResp;
import com.verisign.epp.codec.defReg.EPPDefRegStatus;
import com.verisign.epp.codec.defReg.EPPDefRegTransferCmd;
import com.verisign.epp.codec.defReg.EPPDefRegTransferResp;
import com.verisign.epp.codec.defReg.EPPDefRegUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.idnext.EPPIdnLangTag;
import com.verisign.epp.framework.EPPDefRegHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.SessionData;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefRegHandler
extends EPPDefRegHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "EXAMPLE1-REP";
    private static Logger cat = LoggerFactory.getLogger(DefRegHandler.class);

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doDefRegCheck(EPPEvent aEvent, Object aData) {
        EPPDefRegCheckCmd theMessage = (EPPDefRegCheckCmd)aEvent.getMessage();
        Vector vObjects = theMessage.getNames();
        Enumeration eObjects = vObjects.elements();
        Vector<EPPDefRegCheckResult> vResults = new Vector<EPPDefRegCheckResult>();
        boolean available = true;
        while (eObjects.hasMoreElements()) {
            EPPDefRegName object = (EPPDefRegName)eObjects.nextElement();
            String defRegName = null;
            String level = null;
            if (object != null) {
                defRegName = object.getName();
                level = object.getLevel();
            }
            EPPDefRegCheckResult checkResult = new EPPDefRegCheckResult(defRegName, level, available);
            if (!available) {
                checkResult.setDefRegReason("In use");
            }
            vResults.addElement(checkResult);
            available = !available;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDefRegCheckResp theResponse = new EPPDefRegCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDefRegRenew(EPPEvent aEvent, Object aData) {
        EPPDefRegRenewCmd theMessage = (EPPDefRegRenewCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDefRegRenewResp theResponse = new EPPDefRegRenewResp(transId, theMessage.getRoid(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDefRegDelete(EPPEvent aEvent, Object aData) {
        EPPDefRegDeleteCmd theMessage = (EPPDefRegDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDefRegCreate(EPPEvent aEvent, Object aData) {
        EPPDefRegCreateCmd theMessage = (EPPDefRegCreateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPIdnLangTag idnLang = (EPPIdnLangTag)theMessage.getExtension(EPPIdnLangTag.class);
        if (idnLang != null) {
            String lang = idnLang.getLang();
            cat.info("Language Code: " + lang);
        }
        EPPDefRegCreateResp theResponse = new EPPDefRegCreateResp(transId, theMessage.getDefRegName(), roid, new Date(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDefRegTransfer(EPPEvent aEvent, Object aData) {
        EPPDefRegTransferCmd theMessage = (EPPDefRegTransferCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDefRegTransferResp theResponse = new EPPDefRegTransferResp(transId, roid);
        theResponse.setTransferStatus("pending");
        theResponse.setRequestClient("ClientX");
        theResponse.setRequestDate(new Date());
        theResponse.setActionClient("ClientY");
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDefRegUpdate(EPPEvent aEvent, Object aData) {
        EPPDefRegUpdateCmd theMessage = (EPPDefRegUpdateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDefRegInfo(EPPEvent aEvent, Object aData) {
        EPPDefRegInfoCmd theMessage = (EPPDefRegInfoCmd)aEvent.getMessage();
        Vector<EPPDefRegStatus> statuses = new Vector<EPPDefRegStatus>();
        statuses.addElement(new EPPDefRegStatus("ok"));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDefRegInfoResp theResponse = new EPPDefRegInfoResp(transId, new EPPDefRegName("premium", "do"), roid, "jd1234", "XYZ-123", "US", new Date(), "sh8013", statuses, "ClientY", "sh8013", new Date(), new EPPAuthInfo("2fooBAR"));
        GregorianCalendar theCal = new GregorianCalendar();
        theCal.setTime(new Date());
        theCal.add(1, 10);
        theResponse.setExpirationDate(theCal.getTime());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }
}

