/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.pool.EPPClientTransIdGenerator;
import com.verisign.epp.pool.EPPPooledSession;
import com.verisign.epp.transport.client.EPPSSLContext;
import org.apache.commons.pool2.PooledObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPSessionPoolableFactory
implements PooledObjectFactory<EPPPooledSession> {
    private static Logger log = LoggerFactory.getLogger(EPPSessionPoolableFactory.class);
    public static long TIMEOUT_UNSET = -1L;
    protected String clientId;
    protected String password;
    protected long absoluteTimeout = TIMEOUT_UNSET;
    protected long minAbsoluteTimeout = TIMEOUT_UNSET;
    protected long maxAbsoluteTimeout = TIMEOUT_UNSET;
    protected long idleTimeout = TIMEOUT_UNSET;
    protected String serverName;
    protected Integer serverPort;
    protected String clientHost = null;
    protected EPPSSLContext sslContext = null;
    protected EPPClientTransIdGenerator clientTransIdGenerator = null;
    protected boolean initSessionOnMake = true;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public void setAbsoluteTimeout(long aAbsoluteTimeout) {
        this.absoluteTimeout = aAbsoluteTimeout;
    }

    public long getMinAbsoluteTimeout() {
        return this.minAbsoluteTimeout;
    }

    public void setMinAbsoluteTimeout(long aMinAbsoluteTimeout) {
        this.minAbsoluteTimeout = aMinAbsoluteTimeout;
    }

    public long getMaxAbsoluteTimeout() {
        return this.maxAbsoluteTimeout;
    }

    public void setMaxAbsoluteTimeout(long aMaxAbsoluteTimeout) {
        this.maxAbsoluteTimeout = aMaxAbsoluteTimeout;
    }

    public boolean isRandomAbsoluteTimeout() {
        log.debug("isRandomAbsoluteTimeout: minAbsoluteTimeout = " + this.minAbsoluteTimeout + ", maxAbsoluteTimeout = " + this.maxAbsoluteTimeout);
        if (this.minAbsoluteTimeout != TIMEOUT_UNSET && this.maxAbsoluteTimeout != TIMEOUT_UNSET) {
            if (this.maxAbsoluteTimeout > this.minAbsoluteTimeout) {
                log.debug("isRandomAbsoluteTimeout: returning true");
                return true;
            }
            log.debug("isRandomAbsoluteTimeout: maxAbsoluteTimeout <= minAbsoluteTimeout: returning false");
            return false;
        }
        log.debug("isRandomAbsoluteTimeout: maxAbsoluteTimeout or minAbsoluteTimeout not set: returning false");
        return false;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long aIdleTimeout) {
        this.idleTimeout = aIdleTimeout;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    public EPPSSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(EPPSSLContext aSSLContext) {
        this.sslContext = aSSLContext;
    }

    public EPPClientTransIdGenerator getClientTransIdGenerator() {
        return this.clientTransIdGenerator;
    }

    public void setClientTransIdGenerator(EPPClientTransIdGenerator aClientTransIdGenerator) {
        this.clientTransIdGenerator = aClientTransIdGenerator;
    }

    public boolean isInitSessionOnMake() {
        return this.initSessionOnMake;
    }

    public void setInitSessionOnMake(boolean aInitSessionOnMake) {
        this.initSessionOnMake = aInitSessionOnMake;
    }
}

