/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPClientTransIdGenerator;
import com.verisign.epp.pool.EPPPooledSession;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.pool.EPPSessionPoolableFactory;
import com.verisign.epp.pool.EPPSystemSessionPool;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EnvException;
import com.verisign.epp.util.Environment;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSessionPool {
    public static final long DEFAULT_ABSOLUTE_TIMEOUT = 86400000L;
    public static final long DEFAULT_IDLE_TIMEOUT = 600000L;
    public static final long DEFAULT_MAX_WAIT = 60000L;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final int DEFAULT_MAX_IDLE = 10;
    public static final int DEFAULT_MAX_TOTAL = 10;
    public static final int DEFAULT_MIN_IDLE = 0;
    private static long TIMEOUT_UNSET = -1L;
    private static final boolean DEFAULT_INIT_MAX_TOTAL = false;
    private static final int DEFAULT_BORROW_RETRIES = 0;
    private static final String PROP_PREFIX = "EPP.SessionPool";
    private static Logger log = LoggerFactory.getLogger(EPPSessionPool.class);
    private GenericObjectPool<EPPPooledSession> pool = null;
    private Map systemPools = new HashMap();
    protected static EPPSessionPool instance = new EPPSessionPool();
    private GenericObjectPoolConfig<EPPPooledSession> config = new GenericObjectPoolConfig();
    private EPPSessionPoolableFactory factory;
    private boolean initMaxTotal = false;
    private int borrowRetries = 0;
    private String clientId;
    private String password;
    private long idleTimeout;
    private long absoluteTimeout = TIMEOUT_UNSET;
    private long minAbsoluteTimeout = TIMEOUT_UNSET;
    private long maxAbsoluteTimeout = TIMEOUT_UNSET;
    private String serverName;
    private Integer serverPort;
    private String clientHost = null;
    private boolean initSessionOnMake = true;
    public static final String DEFAULT = "default";

    protected EPPSessionPool() {
    }

    public static EPPSessionPool getInstance() {
        return instance;
    }

    public void init(EPPSessionPoolableFactory aFactory, GenericObjectPoolConfig<EPPPooledSession> aConfig) {
        this.pool = new GenericObjectPool((PooledObjectFactory)aFactory, aConfig);
    }

    public void init() throws EPPSessionPoolException {
        try {
            String theValue = this.getProperty("systemPools");
            if (theValue == null) {
                log.info("Initializing a single session pool");
                this.initSinglePool();
            } else {
                log.info("Initializing system session pools with systems = " + theValue);
                this.initSystemPools(theValue);
            }
        }
        catch (EnvException ex) {
            throw new EPPSessionPoolException("init(): EnvException: " + ex);
        }
    }

    public void close() {
        log.info("close(): closing pool");
        if (this.pool != null) {
            this.pool.clear();
            try {
                this.pool.close();
            }
            catch (Exception ex) {
                log.error("EPPSessionPool.close(): Exception closing default pool <" + this.pool + ">: " + ex);
            }
        }
        if (this.systemPools != null) {
            Set theSystemKeys = this.systemPools.keySet();
            for (String theCurrKey : theSystemKeys) {
                EPPSystemSessionPool theCurrPool = (EPPSystemSessionPool)this.systemPools.get(theCurrKey);
                theCurrPool.close();
            }
        }
        log.info("close(): pool closed");
    }

    private void initSystemPools(String aPoolsProp) throws EPPSessionPoolException {
        log.debug("initSystemPools: enter, aPoolProp = " + aPoolsProp);
        StringTokenizer thePools = new StringTokenizer(aPoolsProp, ",");
        while (thePools.hasMoreTokens()) {
            String theSystem = thePools.nextToken();
            if (theSystem.equals(DEFAULT)) {
                log.info("initSystemPools: Initializing the default pool");
                this.initSinglePool();
                continue;
            }
            log.info("initSystemPools: Initializing " + theSystem + " system pool");
            EPPSystemSessionPool theSessionPool = new EPPSystemSessionPool(theSystem);
            theSessionPool.init();
            this.systemPools.put(theSystem, theSessionPool);
        }
        log.debug("initSystemPools: exit");
    }

    private void initSinglePool() throws EPPSessionPoolException {
        log.debug("initSinglePool: enter");
        try {
            String theValue = this.getProperty("poolableFactoryClassName");
            if (theValue == null) {
                theValue = "com.verisign.epp.pool.EPPGenericSessionPoolableFactory";
            }
            log.info("initSinglePool(): session poolable factory = " + theValue);
            Class<?> thePoolableFactoryClass = Class.forName(theValue);
            this.factory = (EPPSessionPoolableFactory)thePoolableFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.clientId = this.getProperty("clientId");
            if (this.clientId == null) {
                log.error("initSinglePool(): clientId not defined");
                throw new EPPSessionPoolException("clientId not defined");
            }
            this.password = this.getProperty("password");
            if (this.password == null) {
                log.error("initSinglePool(): password not defined");
                throw new EPPSessionPoolException("password not defined");
            }
            theValue = this.getProperty("absoluteTimeout");
            if (theValue != null) {
                this.absoluteTimeout = Long.parseLong(theValue);
                log.info("initSinglePool(): absolute timeout = " + this.absoluteTimeout + " ms");
            } else {
                this.absoluteTimeout = 86400000L;
                log.info("initSinglePool(): default absolute timeout = " + this.absoluteTimeout + " ms");
            }
            theValue = this.getProperty("minAbsoluteTimeout");
            if (theValue != null) {
                this.minAbsoluteTimeout = Long.parseLong(theValue);
                log.info("initSinglePool(): min absolute timeout = " + this.minAbsoluteTimeout + " ms");
            } else {
                log.info("initSinglePool(): min absolute timeout not set");
            }
            theValue = this.getProperty("maxAbsoluteTimeout");
            if (theValue != null) {
                this.maxAbsoluteTimeout = Long.parseLong(theValue);
                log.info("initSinglePool(): max absolute timeout = " + this.maxAbsoluteTimeout + " ms");
            } else {
                log.info("initSinglePool(): max absolute timeout not set");
            }
            theValue = this.getProperty("idleTimeout");
            this.idleTimeout = theValue != null ? Long.parseLong(theValue) : 600000L;
            log.info("initSinglePool(): idle timeout = " + this.idleTimeout + " ms");
            theValue = this.getProperty("clientTransIdGenerator");
            log.info("initSinglePool(): client trans id generator = " + theValue);
            if (theValue != null) {
                try {
                    this.factory.setClientTransIdGenerator((EPPClientTransIdGenerator)Class.forName(theValue).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception ex) {
                    log.error("initSinglePool(): Exception creating instance of class " + theValue + ": " + ex);
                    throw new EPPSessionPoolException("Exception creating instance of class " + theValue + ": " + ex);
                }
            }
            this.config.setMinEvictableIdleTimeMillis(0L);
            theValue = this.getProperty("maxIdle");
            if (theValue != null) {
                this.config.setMaxIdle(Integer.parseInt(theValue));
            } else {
                this.config.setMaxIdle(10);
            }
            log.info("initSinglePool(): max idle = " + this.config.getMaxIdle());
            theValue = this.getProperty("maxTotal");
            if (theValue == null) {
                theValue = this.getProperty("maxActive");
            }
            if (theValue != null) {
                this.config.setMaxTotal(Integer.parseInt(theValue));
            } else {
                this.config.setMaxTotal(10);
            }
            log.info("initSinglePool(): max Total = " + this.config.getMaxTotal());
            theValue = this.getProperty("initMaxTotal");
            if (theValue == null) {
                theValue = this.getProperty("initMaxActive");
            }
            this.initMaxTotal = theValue != null ? Boolean.valueOf(theValue) : false;
            log.info("initSinglePool(): init max Total = " + this.initMaxTotal);
            theValue = this.getProperty("borrowRetries");
            this.borrowRetries = theValue != null ? Integer.parseInt(theValue) : 0;
            log.info("initSinglePool(): borrow retries = " + this.borrowRetries);
            theValue = this.getProperty("maxWait");
            if (theValue != null) {
                this.config.setMaxWaitMillis((long)Integer.parseInt(theValue));
            } else {
                this.config.setMaxWaitMillis(60000L);
            }
            log.info("initSinglePool(): max wait = " + this.config.getMaxWaitMillis());
            theValue = this.getProperty("minIdle");
            if (theValue != null) {
                this.config.setMinIdle(Integer.parseInt(theValue));
            } else {
                this.config.setMinIdle(0);
            }
            log.info("initSinglePool(): min idle = " + this.config.getMinIdle());
            this.config.setNumTestsPerEvictionRun(-1);
            this.config.setTestOnBorrow(false);
            this.config.setTestOnReturn(false);
            this.config.setTestWhileIdle(true);
            theValue = this.getProperty("timeBetweenEvictionRunsMillis");
            if (theValue != null) {
                this.config.setTimeBetweenEvictionRunsMillis(Long.parseLong(theValue));
            } else {
                this.config.setTimeBetweenEvictionRunsMillis(60000L);
            }
            log.info("initSinglePool(): time between eviction runs = " + this.config.getTimeBetweenEvictionRunsMillis() + " ms");
            this.config.setBlockWhenExhausted(true);
            theValue = this.getProperty("initSessionOnMake");
            if (theValue != null) {
                this.initSessionOnMake = Boolean.parseBoolean(theValue);
            }
            log.info("initSinglePool(): initSessionOnMake = " + this.initSessionOnMake);
            this.serverName = EPPEnv.getServerName();
            log.info("initSinglePool(): serverName = " + this.serverName);
            theValue = Environment.getOption("EPP.ServerPort");
            if (theValue != null && !theValue.isEmpty()) {
                this.serverPort = Integer.valueOf(theValue);
            }
            log.info("initSinglePool(): serverPort = " + this.serverPort);
            this.clientHost = EPPEnv.getClientHost();
            log.info("initSinglePool(): clientHost = " + this.clientHost);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("initSinglePool(): Exception with initializing the single session pool: " + ex);
            throw new EPPSessionPoolException("Exception with initializing the single session pool: " + ex);
        }
        this.factory.setAbsoluteTimeout(this.absoluteTimeout);
        this.factory.setMinAbsoluteTimeout(this.minAbsoluteTimeout);
        this.factory.setMaxAbsoluteTimeout(this.maxAbsoluteTimeout);
        this.factory.setIdleTimeout(this.idleTimeout);
        this.factory.setClientId(this.clientId);
        this.factory.setPassword(this.password);
        this.factory.setServerName(this.serverName);
        this.factory.setServerPort(this.serverPort);
        this.factory.setClientHost(this.clientHost);
        this.init(this.factory, this.config);
        if (this.initMaxTotal && this.config.getMaxTotal() > 0) {
            int i;
            log.info("initSinglePool(): Pre-initialize maxTotal (" + this.config.getMaxTotal() + ") sessions");
            EPPSession[] theSessions = new EPPSession[this.config.getMaxTotal()];
            for (i = 0; i < this.config.getMaxTotal(); ++i) {
                try {
                    theSessions[i] = this.borrowObject();
                    log.info("initSinglePool(): Pre-initialized session #" + (i + 1));
                    continue;
                }
                catch (EPPSessionPoolException ex) {
                    log.error("initSinglePool(): Failure to pre-initialize session #" + (i + 1) + ": " + ex);
                }
            }
            for (i = 0; i < this.config.getMaxTotal(); ++i) {
                if (theSessions[i] == null) continue;
                this.returnObject(theSessions[i]);
                theSessions[i] = null;
            }
        }
        log.debug("initSinglePool: exit");
    }

    public EPPSession borrowObject() throws EPPSessionPoolException {
        if (this.pool == null) {
            log.error("borrowObject(): pool is null");
            throw new EPPSessionPoolException("EPPSessionPool: pool is null");
        }
        EPPSession theSession = null;
        for (int retries = 0; theSession == null && retries <= this.borrowRetries; ++retries) {
            try {
                theSession = (EPPSession)this.pool.borrowObject();
                log.debug("borrowObject(): Session = " + theSession + ", Total = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle());
                continue;
            }
            catch (Exception ex) {
                if (retries >= this.borrowRetries) {
                    log.error("borrowObject(): Final exception on borrow session after " + retries + " retries: " + ex);
                    throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
                }
                log.debug("borrowObject(): Exception on borrow session after " + retries + " retries: " + ex);
            }
        }
        return theSession;
    }

    public EPPSession borrowObject(String aSystem) throws EPPSessionPoolException {
        if (aSystem != null && aSystem.equals(DEFAULT)) {
            return this.borrowObject();
        }
        EPPSystemSessionPool thePool = this.getSystemSessionPool(aSystem);
        EPPSession theSession = null;
        try {
            theSession = thePool.borrowObject();
            log.debug("borrowObject(" + aSystem + "): Session = " + theSession + ", Total = " + thePool.getGenericObjectPool().getNumActive() + ", Idle = " + thePool.getGenericObjectPool().getNumIdle());
        }
        catch (Exception ex) {
            log.error("borrowObject(" + aSystem + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
        return theSession;
    }

    public void invalidateObject(EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error("invalidateObject(" + aSession + "): session is null");
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (!(aSession instanceof EPPPooledSession)) {
            log.error("invalidateObject(" + aSession + "): session not of type " + EPPPooledSession.class.getName());
            throw new EPPSessionPoolException("EPPSessionPool: session not of type " + EPPPooledSession.class.getName());
        }
        if (this.pool == null) {
            log.error("invalidateObject(" + aSession + "): pool is null");
            throw new EPPSessionPoolException("EPPSessionPool: pool is null");
        }
        try {
            this.pool.invalidateObject((Object)((EPPPooledSession)((Object)aSession)));
            log.debug("invalidateObject(" + aSession + "): Total = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle());
        }
        catch (Exception ex) {
            log.error("invalidateObject(" + aSession + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void invalidateObject(String aSystem, EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error("invalidateObject(" + aSystem + ", " + aSession + "): session is null");
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (!(aSession instanceof EPPPooledSession)) {
            log.error("invalidateObject(" + aSystem + ", " + aSession + "): session not of type " + EPPPooledSession.class.getName());
            throw new EPPSessionPoolException("EPPSessionPool: session not of type " + EPPPooledSession.class.getName());
        }
        if (aSystem != null && aSystem.equals(DEFAULT)) {
            this.invalidateObject(aSession);
            return;
        }
        EPPSystemSessionPool thePool = this.getSystemSessionPool(aSystem);
        try {
            thePool.invalidateObject(aSession);
            log.debug("invalidateObject(" + aSystem + ", " + aSession + "): Total = " + thePool.getGenericObjectPool().getNumActive() + ", Idle = " + thePool.getGenericObjectPool().getNumIdle());
        }
        catch (Exception ex) {
            log.error("invalidateObject(" + aSystem + ", " + aSession + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void returnObject(EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error("returnObject(" + aSession + "): session is null");
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (!(aSession instanceof EPPPooledSession)) {
            log.error("returnObject(" + aSession + "): session not of type " + EPPPooledSession.class.getName());
            throw new EPPSessionPoolException("EPPSessionPool: session not of type " + EPPPooledSession.class.getName());
        }
        if (this.pool == null) {
            log.error("returnObject(" + aSession + "): pool is null");
            throw new EPPSessionPoolException("EPPSessionPool: pool is null");
        }
        this.touchSession(aSession);
        try {
            this.pool.returnObject((Object)((EPPPooledSession)((Object)aSession)));
            log.debug("returnObject(" + aSession + "): Total = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle());
        }
        catch (Exception ex) {
            log.error("returnObject(" + aSession + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void returnObject(String aSystem, EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error("returnObject(" + aSystem + ", " + aSession + "): session is null");
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (!(aSession instanceof EPPPooledSession)) {
            log.error("returnObject(" + aSystem + ", " + aSession + "): session not of type " + EPPPooledSession.class.getName());
            throw new EPPSessionPoolException("EPPSessionPool: session not of type " + EPPPooledSession.class.getName());
        }
        if (aSystem != null && aSystem.equals(DEFAULT)) {
            this.returnObject(aSession);
            return;
        }
        EPPSystemSessionPool thePool = this.getSystemSessionPool(aSystem);
        this.touchSession(aSession);
        try {
            thePool.returnObject(aSession);
            log.debug("returnObject(" + aSystem + ", " + aSession + "): Total = " + thePool.getGenericObjectPool().getNumActive() + ", Idle = " + thePool.getGenericObjectPool().getNumIdle());
        }
        catch (Exception ex) {
            log.error("returnObject(" + aSystem + ", " + aSession + "): Caught Exception: " + ex);
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public GenericObjectPool<EPPPooledSession> getGenericObjectPool() {
        return this.pool;
    }

    public boolean hasSystemSessionPool(String aSystem) {
        return this.systemPools.get(aSystem) != null;
    }

    public EPPSystemSessionPool getSystemSessionPool(String aSystem) throws EPPSessionPoolException {
        EPPSystemSessionPool theSystemPool = (EPPSystemSessionPool)this.systemPools.get(aSystem);
        if (theSystemPool == null) {
            log.error("getGenericObjectPool(): Could not find system pool " + aSystem);
            throw new EPPSessionPoolException("Could not find system pool " + aSystem);
        }
        return theSystemPool;
    }

    public GenericObjectPool<EPPPooledSession> getGenericObjectPool(String aSystem) throws EPPSessionPoolException {
        EPPSystemSessionPool theSystemPool = this.getSystemSessionPool(aSystem);
        if (theSystemPool.getGenericObjectPool() == null) {
            log.error("getGenericObjectPool(): GenericObjectPool is null for system pool " + aSystem);
            throw new EPPSessionPoolException("GenericObjectPool is null for system pool " + aSystem);
        }
        return theSystemPool.getGenericObjectPool();
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public long getMinAbsoluteTimeout() {
        return this.minAbsoluteTimeout;
    }

    public long getMaxAbsoluteTimeout() {
        return this.maxAbsoluteTimeout;
    }

    public boolean isRandomAbsoluteTimeout() {
        return this.minAbsoluteTimeout != TIMEOUT_UNSET && this.maxAbsoluteTimeout != TIMEOUT_UNSET && this.maxAbsoluteTimeout > this.minAbsoluteTimeout;
    }

    public String getClientId() {
        return this.clientId;
    }

    public GenericObjectPoolConfig<EPPPooledSession> getConfig() {
        return this.config;
    }

    public EPPSessionPoolableFactory getFactory() {
        return this.factory;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    public boolean isInitSessionOnMake() {
        return this.initSessionOnMake;
    }

    public void setInitSessionOnMake(boolean aInitSessionOnMake) {
        this.initSessionOnMake = aInitSessionOnMake;
    }

    private String getProperty(String aProperty) throws EnvException {
        return Environment.getProperty("EPP.SessionPool." + aProperty);
    }

    private void touchSession(EPPSession aSession) throws EPPSessionPoolException {
        if (!(aSession instanceof EPPPooledSession)) {
            log.error("touchSession(" + aSession + "): Session class " + aSession.getClass().getName() + " does not implement EPPPooledSession");
            throw new EPPSessionPoolException("EPPSessionPool: Session class " + aSession.getClass().getName() + " does not implement EPPPooledSession");
        }
        ((EPPPooledSession)((Object)aSession)).touch();
    }
}

