/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.v1_0;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.ttl.v1_0.EPPTtl;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlCreate;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfData;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfo;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlUpdate;
import com.verisign.epp.codec.ttl.v1_0.RRecType;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPHost;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPTtlTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPTtlTst.class);
    private EPPDomain domain = null;
    private EPPHost host = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testTtl() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainInfo();
            this.hostInfo();
            this.domainCreate();
            this.hostCreate();
            this.domainUpdate();
            this.hostUpdate();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void domainInfo() {
        EPPDomainInfoResp theResponse;
        this.printStart("domainInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainInfo: Info domain with TTL extension and policy default value of false");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("ttl-example.com");
            this.domain.addExtension(new EPPTtlInfo());
            theResponse = this.domain.sendInfo();
            System.out.println("\ndomainInfo: Response = [" + theResponse + "]");
            assert (theResponse.hasExtension(EPPTtlInfData.class));
            System.out.println("domainInfo: Response TTL data = " + (EPPTtlInfData)theResponse.getExtension(EPPTtlInfData.class));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainInfo: Info domain with TTL extension and policy set to false");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("ttl-example.com");
            this.domain.addExtension(new EPPTtlInfo(false));
            theResponse = this.domain.sendInfo();
            System.out.println("\ndomainInfo: Response = [" + theResponse + "]");
            assert (theResponse.hasExtension(EPPTtlInfData.class));
            System.out.println("domainInfo: Response TTL data = " + (EPPTtlInfData)theResponse.getExtension(EPPTtlInfData.class));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainInfo: Info domain with TTL extension and with policy set to true");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("ttl-example.com");
            this.domain.addExtension(new EPPTtlInfo(true));
            theResponse = this.domain.sendInfo();
            System.out.println("\ndomainInfo: Response = [" + theResponse + "]");
            assert (theResponse.hasExtension(EPPTtlInfData.class));
            System.out.println("domainInfo: Response TTL data = " + (EPPTtlInfData)theResponse.getExtension(EPPTtlInfData.class));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainInfo");
    }

    private void hostInfo() {
        EPPHostInfoResp theResponse;
        this.printStart("hostInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostInfo: Info host with TTL extension and policy default value of false");
            this.host.setTransId("ABC-12345");
            this.host.addHostName("ttl-ns1.example.com");
            this.host.addExtension(new EPPTtlInfo());
            theResponse = this.host.sendInfo();
            System.out.println("\nhostInfo: Response = [" + theResponse + "]");
            assert (theResponse.hasExtension(EPPTtlInfData.class));
            System.out.println("hostInfo: Response TTL data = " + (EPPTtlInfData)theResponse.getExtension(EPPTtlInfData.class));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostInfo: Info host with TTL extension and with policy set to false");
            this.host.setTransId("ABC-12345");
            this.host.addHostName("ttl-ns1.example.com");
            this.host.addExtension(new EPPTtlInfo(false));
            theResponse = this.host.sendInfo();
            System.out.println("\nhostInfo: Response = [" + theResponse + "]");
            assert (theResponse.hasExtension(EPPTtlInfData.class));
            System.out.println("hostInfo: Response TTL data = " + (EPPTtlInfData)theResponse.getExtension(EPPTtlInfData.class));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostInfo: Info host with TTL extension and with policy set to true");
            this.host.setTransId("ABC-12345");
            this.host.addHostName("ttl-ns1.example.com");
            this.host.addExtension(new EPPTtlInfo(true));
            theResponse = this.host.sendInfo();
            System.out.println("\nhostInfo: Response = [" + theResponse + "]");
            assert (theResponse.hasExtension(EPPTtlInfData.class));
            System.out.println("hostInfo: Response TTL data = " + (EPPTtlInfData)theResponse.getExtension(EPPTtlInfData.class));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostInfo");
    }

    public void domainCreate() {
        this.printStart("domainCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainCreate: Create domain ttl-example.com with TTL extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("ttl-example.com");
            this.domain.setAuthString("");
            this.domain.addHostName("ns1.example.com");
            this.domain.addHostName("ns1.example.net");
            EPPTtlCreate theTtlExt = new EPPTtlCreate();
            theTtlExt.addTtl(new EPPTtl(RRecType.NS, 172800));
            theTtlExt.addTtl(new EPPTtl(RRecType.DS, 300));
            theTtlExt.addTtl(new EPPTtl(RRecType.CUSTOM, "DELEG", 3600));
            this.domain.addExtension(theTtlExt);
            EPPSecDNSExtCreate theDnssecExt = new EPPSecDNSExtCreate();
            theDnssecExt.appendDsData(new EPPSecDNSExtDsData(12345, 13, 2, "49FD46E6C4B45C55D4AC"));
            this.domain.addExtension(theDnssecExt);
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            assert (response.isSuccess());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCreate");
    }

    public void hostCreate() {
        this.printStart("hostCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostCreate: Create host ttl-ns1.example.com with TTL extension");
            this.host.setTransId("ABC-12345");
            this.host.addHostName("ttl-ns1.example.com");
            this.host.addIPV4Address("192.0.2.2");
            this.host.addIPV6Address("1080::8:800:200C:417A");
            EPPTtlCreate theCreateExt = new EPPTtlCreate();
            theCreateExt.addTtl(new EPPTtl(RRecType.A));
            theCreateExt.addTtl(new EPPTtl(RRecType.AAAA, 86400));
            this.host.addExtension(theCreateExt);
            EPPResponse response = this.host.sendCreate();
            System.out.println("hostCreate: Response = [" + response + "]\n\n");
            assert (response.isSuccess());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostCreate");
    }

    public void domainUpdate() {
        this.printStart("domainUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("domainUpdate: Update domain ttl-example.com with TTL extension");
            this.domain.setTransId("ABC-12345");
            this.domain.addDomainName("ttl-example.com");
            EPPTtlUpdate theUpdateExt = new EPPTtlUpdate();
            theUpdateExt.addTtl(new EPPTtl(RRecType.NS));
            this.domain.addExtension(theUpdateExt);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
            assert (response.isSuccess());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdate");
    }

    public void hostUpdate() {
        this.printStart("hostUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostUpdate: Update host ttl-ns1.example.com with TTL extension");
            this.host.setTransId("ABC-12345");
            this.host.addHostName("ttl-ns1.example.com");
            EPPTtlUpdate theUpdateExt = new EPPTtlUpdate();
            theUpdateExt.addTtl(new EPPTtl(RRecType.A, 86400));
            theUpdateExt.addTtl(new EPPTtl(RRecType.AAAA, 3600));
            this.host.addExtension(theUpdateExt);
            EPPResponse response = this.host.sendUpdate();
            System.out.println("hostUpdate: Response = [" + response + "]\n\n");
            assert (response.isSuccess());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
        this.host = new EPPHost(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String aBaseDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + aBaseDomainName);
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

