/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.v1_0;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceDescription;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoCmd;
import com.verisign.epp.codec.maintenance.v1_0.EPPMaintenanceInfoResp;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.interfaces.v1_0.EPPMaintenance;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPMaintenanceTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceTst.class);
    private EPPMaintenance maintenance = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPMaintenanceTst(String name) {
        super(name);
    }

    public void testMaintenance() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.maintenanceInfo();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void maintenanceInfo() {
        this.printStart("maintenanceInfo");
        this.clearPollQueue();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("maintenanceInfo: List Info.");
            this.maintenance.setTransId("ABC-12345");
            this.maintenance.setInfoType(EPPMaintenanceInfoCmd.InfoType.list);
            EPPMaintenanceInfoResp response = this.maintenance.sendInfo();
            System.out.println("maintenanceInfo: Maintenance List Info Response = [" + response + "]\n\n");
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("maintenanceInfo: Id.");
            this.maintenance.setTransId("ABC-12345");
            this.maintenance.setInfoType(EPPMaintenanceInfoCmd.InfoType.id);
            this.maintenance.setMaintenanceId("2e6df9b0-4092-4491-bcc8-9fb2166dcee6");
            response = this.maintenance.sendInfo();
            System.out.println("maintenanceInfo: Maintenance List Id Response = [" + response + "]\n\n");
            if (response.getMaintenance().hasDescriptions()) {
                for (EPPMaintenanceDescription description : response.getMaintenance().getDescriptions()) {
                    System.out.println("maintenanceInfo: description =\n" + description.getDescription());
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("maintenanceInfo");
    }

    public void testMaintenancePoll() {
        this.printStart("testMaintenancePoll");
        this.clearPollQueue();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("testMaintenancePoll: insert-maintenance-poll-msg Id.");
            this.maintenance.setTransId("ABC-12345");
            this.maintenance.setInfoType(EPPMaintenanceInfoCmd.InfoType.id);
            this.maintenance.setMaintenanceId("insert-maintenance-poll-msg");
            this.maintenance.sendInfo();
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("testMaintenancePoll: Get poll message.");
            this.session.setTransId("ABC-12345");
            this.session.setPollOp("req");
            EPPResponse reqResponse = this.session.sendPoll();
            System.out.println("testMaintenancePoll: Poll Request Response = [" + reqResponse + "]\n\n");
            Assert.assertEquals((int)1301, (int)reqResponse.getResult().getCode());
            Assert.assertTrue((boolean)(reqResponse instanceof EPPMaintenanceInfoResp));
            this.session.setPollOp("ack");
            this.session.setMsgID(reqResponse.getMsgQueue().getId());
            EPPResponse ackResponse = this.session.sendPoll();
            System.out.println("testMaintenancePoll: Poll Ack Response = [" + ackResponse + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("testMaintenancePoll");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.maintenance = new EPPMaintenance(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPMaintenanceTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPMaintenanceTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPMaintenanceTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }

    public void clearPollQueue() {
        try {
            EPPResponse reqResponse = null;
            do {
                this.session.setTransId("ABC-12345");
                this.session.setPollOp("req");
                reqResponse = this.session.sendPoll();
                System.out.println("clearPollQueue: Poll Request Response = [" + reqResponse + "]\n\n");
                if (reqResponse.getResult().getCode() != 1301) continue;
                this.session.setPollOp("ack");
                this.session.setMsgID(reqResponse.getMsgQueue().getId());
                EPPResponse ackResponse = this.session.sendPoll();
                System.out.println("clearPollQueue: Poll Ack Response = [" + ackResponse + "]\n\n");
            } while (reqResponse != null && reqResponse.getResult().getCode() == 1301);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }
}

