/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.addlemail;

import com.verisign.epp.codec.addlemail.EPPAddlEmail;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPContact;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import java.util.Vector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPAddlEmailTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPAddlEmailTst.class);
    private EPPContact contact = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testContact() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.contactCreate();
            this.contactUpdate();
            this.contactInfo();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void contactCreate() {
        EPPResponse response;
        EPPContactPostalDefinition name;
        EPPContactAddress address;
        Vector<String> streets;
        this.printStart("contactCreate");
        String theName = "AE-1";
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreate: Contact create for with ASCII as alternate address for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("1234");
            this.contact.setFaxNumber("+1.7035555556");
            this.contact.setEmail("jdoe@example.com");
            streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            name = new EPPContactPostalDefinition("loc");
            name.setName("John Doe");
            name.setOrg("Example Inc.");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            this.contact.addExtension(new EPPAddlEmail("jdoe-alternate@example.com"));
            response = this.contact.sendCreate();
            System.out.println("contactCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        theName = "AE-2";
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreate: Contact create with SMTPUTF8 as alternate primary address for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("1234");
            this.contact.setFaxNumber("+1.7035555556");
            this.contact.setEmail("jdoe@example.com");
            streets = new Vector();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            name = new EPPContactPostalDefinition("int");
            name.setName("John Doe");
            name.setOrg("Example Inc.");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            this.contact.addExtension(new EPPAddlEmail("\u9ea5\u514b\u98a8@example.com", true));
            response = this.contact.sendCreate();
            System.out.println("contactCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactCreate");
    }

    public void contactUpdate() {
        EPPResponse response;
        String theName;
        this.printStart("contactUpdate");
        try {
            theName = "AE-1";
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactUpdate: Contact update to set ASCII alternate email for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            this.contact.addExtension(new EPPAddlEmail("jdoe-alternate@example.com"));
            response = this.contact.sendUpdate();
            System.out.println("contactUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            theName = "AE-2";
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactUpdate: Contact update to set SMTPUTF8 alternate email for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            this.contact.setEmail("jdoe@example.com");
            this.contact.addExtension(new EPPAddlEmail("\u9ea5\u514b\u98a8@example.com"));
            response = this.contact.sendUpdate();
            System.out.println("contactUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            theName = "AE-3";
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactUpdate: Contact update to unset alternate email for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            this.contact.addExtension(new EPPAddlEmail());
            response = this.contact.sendUpdate();
            System.out.println("contactUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactUpdate");
    }

    public void contactInfo() {
        EPPContactInfoResp response;
        String theName;
        this.printStart("contactInfo");
        try {
            theName = "AE-1";
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo: Contact info for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            response = this.contact.sendInfo();
            System.out.println("contactInfo: Response = [" + response + "]\n\n");
            System.out.println("contactInfo: id = " + response.getId());
            Assert.assertNotNull((Object)response.getEmail());
            Assert.assertTrue((boolean)response.hasExtension(EPPAddlEmail.class));
            System.out.println("contactInfo: email = " + response.getEmail());
            System.out.println("contactInfo: alt email = " + ((EPPAddlEmail)response.getExtension(EPPAddlEmail.class)).getEmail());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            theName = "AE-2";
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo: Contact info for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            response = this.contact.sendInfo();
            System.out.println("contactInfo: Response = [" + response + "]\n\n");
            System.out.println("contactInfo: id = " + response.getId());
            Assert.assertNotNull((Object)response.getEmail());
            Assert.assertTrue((boolean)response.hasExtension(EPPAddlEmail.class));
            System.out.println("contactInfo: email = " + response.getEmail());
            System.out.println("contactInfo: alt email = " + ((EPPAddlEmail)response.getExtension(EPPAddlEmail.class)).getEmail());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            theName = "AE-3";
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo: Contact info for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            response = this.contact.sendInfo();
            System.out.println("contactInfo: Response = [" + response + "]\n\n");
            System.out.println("contactInfo: id = " + response.getId());
            Assert.assertNotNull((Object)response.getEmail());
            Assert.assertTrue((boolean)response.hasExtension(EPPAddlEmail.class));
            System.out.println("contactInfo: email = " + response.getEmail());
            System.out.println("contactInfo: alt email = " + ((EPPAddlEmail)response.getExtension(EPPAddlEmail.class)).getEmail());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactInfo");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.contact = new EPPContact(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = ((EPPCommandException)aException).getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("AE-" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

