/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;

public class EPPRelatedDomain
extends EPPDomain {
    public static final String DOMAIN_INFO_FORM = EPPRelatedDomainExtInfo.TYPE_DOMAIN;
    public static final String RELATED_INFO_FORM = EPPRelatedDomainExtInfo.TYPE_RELATED;
    private String infoForm = DOMAIN_INFO_FORM;
    private List<EPPRelatedDomainExtDomain> relatedDomains = null;
    private List<String> relatedNames = null;

    public EPPRelatedDomain(EPPSession aSession) {
        super(aSession);
    }

    public void addRelatedDomain(EPPRelatedDomainExtDomain aRelatedDomain) {
        if (this.relatedDomains == null) {
            this.relatedDomains = new ArrayList<EPPRelatedDomainExtDomain>();
        }
        this.relatedDomains.add(aRelatedDomain);
    }

    public void addRelatedName(String aRelatedName) {
        if (this.relatedNames == null) {
            this.relatedNames = new ArrayList<String>();
        }
        this.relatedNames.add(aRelatedName);
    }

    public EPPResponse sendRelatedInfo() throws EPPCommandException {
        EPPResponse response;
        block3: {
            EPPRelatedDomainExtInfo theExt = new EPPRelatedDomainExtInfo(this.infoForm);
            super.addExtension(theExt);
            try {
                response = super.sendInfo();
            }
            catch (EPPCommandException ex) {
                response = super.getResponse();
                if (response == null) {
                    throw new EPPCommandException("EPPRelatedDomain.sendRelatedInfo : Error sending command", response);
                }
                if (response.isSuccess()) break block3;
                throw new EPPCommandException("EPPRelatedDomain.sendRelatedInfo : Error in response from Server", response);
            }
        }
        this.resetDomain();
        return response;
    }

    public EPPDomainCreateResp sendRelatedCreate() throws EPPCommandException {
        if (this.relatedDomains == null || this.relatedDomains.isEmpty()) {
            throw new EPPCommandException("EPPRelatedDomain.sendRelatedCreate : No related domains defined.");
        }
        EPPRelatedDomainExtCreate create = new EPPRelatedDomainExtCreate();
        create.setDomains(this.relatedDomains);
        super.addExtension(create);
        EPPDomainCreateResp response = super.sendCreate();
        this.resetDomain();
        return response;
    }

    public EPPResponse sendRelatedDelete() throws EPPCommandException {
        if (this.relatedNames == null || this.relatedNames.isEmpty()) {
            throw new EPPCommandException("EPPRelatedDomain.sendRelatedDelete : No related domain names defined.");
        }
        EPPRelatedDomainExtDelete delete = new EPPRelatedDomainExtDelete();
        delete.setDomains(this.relatedNames);
        super.addExtension(delete);
        EPPResponse response = super.sendDelete();
        this.resetDomain();
        return response;
    }

    public EPPDomainTransferResp sendRelatedTransfer() throws EPPCommandException {
        if (this.relatedDomains == null || this.relatedDomains.isEmpty()) {
            throw new EPPCommandException("EPPRelatedDomain.sendRelatedTransfer : No related domains defined.");
        }
        EPPRelatedDomainExtTransfer transfer = new EPPRelatedDomainExtTransfer();
        transfer.setDomains(this.relatedDomains);
        super.addExtension(transfer);
        EPPDomainTransferResp response = super.sendTransfer();
        this.resetDomain();
        return response;
    }

    public EPPDomainRenewResp sendRelatedRenew() throws EPPCommandException {
        if (this.relatedDomains == null || this.relatedDomains.isEmpty()) {
            throw new EPPCommandException("EPPRelatedDomain.sendRelatedRenew : No related domains defined.");
        }
        EPPRelatedDomainExtRenew renew = new EPPRelatedDomainExtRenew();
        renew.setDomains(this.relatedDomains);
        super.addExtension(renew);
        EPPDomainRenewResp response = super.sendRenew();
        this.resetDomain();
        return response;
    }

    public EPPResponse sendRelatedUpdate() throws EPPCommandException {
        if (this.relatedNames == null || this.relatedNames.isEmpty()) {
            throw new EPPCommandException("EPPRelatedDomain.sendRelatedUpdate : No related domain names defined.");
        }
        EPPRelatedDomainExtUpdate update = new EPPRelatedDomainExtUpdate();
        update.setDomains(this.relatedNames);
        super.addExtension(update);
        EPPResponse response = super.sendUpdate();
        this.resetDomain();
        return response;
    }

    @Override
    protected void resetDomain() {
        super.resetDomain();
        this.relatedDomains = null;
        this.relatedNames = null;
        this.infoForm = DOMAIN_INFO_FORM;
    }

    public void setInfoForm(String aType) {
        this.infoForm = aType;
    }
}

