/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPQuicSessionTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = LoggerFactory.getLogger(EPPQuicSessionTst.class);
    private EPPSession session = null;

    public EPPQuicSessionTst(String name) {
        super(name);
    }

    public void testSession() {
        this.initSession();
        this.doHello();
        this.doPoll();
        this.doPollConsume();
        this.endSession();
    }

    private void initSession() {
        EPPQuicSessionTst.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPQuicSessionTst.printEnd("initSession");
    }

    private void doHello() {
        EPPQuicSessionTst.printStart("Session Hello");
        try {
            this.session.hello();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPQuicSessionTst.printEnd("Session Hello");
    }

    private void doPoll() {
        EPPQuicSessionTst.printStart("doPoll");
        EPPResponse response = null;
        Long numMsgs = null;
        try {
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            System.out.println("doPoll: Response = [" + response + "]\n\n");
            numMsgs = response.getMsgQueueCount();
            if (numMsgs != null) {
                System.out.println("doPoll: # messages = " + numMsgs);
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setPollOp("ack");
            this.session.setMsgID("1234");
            response = this.session.sendPoll();
            System.out.println("doPoll: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            System.out.println("doPoll: Error Response = [" + e.getResponse() + "]\n\n");
        }
        EPPQuicSessionTst.printEnd("doPoll");
    }

    private void doPollConsume() {
        EPPQuicSessionTst.printStart("doPollConsume");
        EPPResponse response = null;
        try {
            this.session.setTransId("ABC-" + System.currentTimeMillis());
            this.session.setPollOp("req");
            response = this.session.sendPoll();
            while (response.getResult().getCode() == 1301) {
                System.out.println("doPollConsume: Message = [" + response + "]\n\n");
                this.session.setTransId("ABC-" + System.currentTimeMillis());
                this.session.setPollOp("ack");
                this.session.setMsgID(response.getMsgQueue().getId());
                response = this.session.sendPoll();
                this.session.setTransId("ABC-" + System.currentTimeMillis());
                this.session.setPollOp("req");
                response = this.session.sendPoll();
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPQuicSessionTst.printEnd("doPollConsume");
    }

    private void endSession() {
        EPPQuicSessionTst.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        EPPQuicSessionTst.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPQuicSessionTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPQuicSessionTst Thread " + i, EPPQuicSessionTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPQuicSessionTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public void handleException(EPPCommandException aException) {
        EPPResponse response = this.session.getResponse();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            aException.printStackTrace();
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

