/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.org.EPPOrgAddress;
import com.verisign.epp.codec.org.EPPOrgCheckResp;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgCreateResp;
import com.verisign.epp.codec.org.EPPOrgInfoResp;
import com.verisign.epp.codec.org.EPPOrgPendActionMsg;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgRoleStatus;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPOrg;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPOrgTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPOrgTst.class);
    private EPPOrg org = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testOrg() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.orgCheck();
            this.orgInfo();
            this.orgCreate();
            this.orgCreatePending();
            this.orgDelete();
            this.orgUpdate();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void orgCheck() {
        this.printStart("orgCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("orgCheck: Check res1523, re1523, and 1523res org identifiers.");
            this.org.setTransId("ABC-12345");
            this.org.addOrgId("res1523");
            this.org.addOrgId("re1523");
            this.org.addOrgId("1523res");
            EPPOrgCheckResp response = this.org.sendCheck();
            System.out.println("orgCheck: Org Check Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainCheck");
    }

    public void orgInfo() {
        this.printStart("orgInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("orgInfo: Info res1523.");
            this.org.setTransId("ABC-12345");
            this.org.addOrgId("res1523");
            EPPOrgInfoResp response = this.org.sendInfo();
            System.out.println("orgInfo: Org Info Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("orgInfo");
    }

    public void orgCreate() {
        this.printStart("orgCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("orgCreate: Create res1523.");
            this.org.setTransId("ABC-12345");
            this.org.addOrgId("res1523");
            this.org.addRole(new EPPOrgRole("reseller", EPPOrgRoleStatus.ok, null));
            this.org.addRole(new EPPOrgRole("privacyproxy", EPPOrgRoleStatus.ok, null));
            this.org.setParentId("1523res");
            EPPOrgAddress theAddress = new EPPOrgAddress();
            theAddress.setStreets("124 Example Dr.", "Suite 200");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            this.org.addPostalInfo(new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT, "Example Organization Inc.", theAddress));
            this.org.setVoice("+1.7035555555");
            this.org.setVoiceExt("1234");
            this.org.setFax("+1.7035555556");
            this.org.setEmail("contact@organization.example");
            this.org.setUrl("http://organization.example");
            this.org.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.ADMINISTRATIVE));
            this.org.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.BILLING));
            EPPOrgCreateResp response = this.org.sendCreate();
            System.out.println("orgCreate: Org Create Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("orgCreate");
    }

    public void orgCreatePending() {
        this.printStart("orgCreatePending");
        try {
            System.out.println("orgCreatePending: Clearing poll queue");
            this.session.setPollOp("req");
            EPPResponse thePollResponse = this.session.sendPoll();
            while (thePollResponse.getResult().getCode() == 1301) {
                this.session.setPollOp("ack");
                this.session.setMsgID(thePollResponse.getMsgQueue().getId());
                thePollResponse = this.session.sendPoll();
                this.session.setPollOp("req");
                thePollResponse = this.session.sendPoll();
            }
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("orgCreatePending: Create PENDING.");
            this.org.setTransId("ABC-12345");
            this.org.addOrgId("PENDING");
            this.org.addRole(new EPPOrgRole("reseller", EPPOrgRoleStatus.ok, null));
            this.org.addRole(new EPPOrgRole("privacyproxy", EPPOrgRoleStatus.ok, null));
            this.org.setParentId("1523res");
            EPPOrgAddress theAddress = new EPPOrgAddress();
            theAddress.setStreets("124 Example Dr.", "Suite 200");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            this.org.addPostalInfo(new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT, "Example Organization Inc.", theAddress));
            this.org.setVoice("+1.7035555555");
            this.org.setVoiceExt("1234");
            this.org.setFax("+1.7035555556");
            this.org.setEmail("contact@organization.example");
            this.org.setUrl("http://organization.example");
            this.org.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.ADMINISTRATIVE));
            this.org.addContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.BILLING));
            EPPOrgCreateResp response = this.org.sendCreate();
            Assert.assertEquals((long)1001L, (long)response.getResult().getCode());
            System.out.println("orgCreatePending: Org Create Response = [" + response + "]\n\n");
            System.out.println("orgCreatePending: Get pending action poll message");
            this.session.setPollOp("req");
            thePollResponse = this.session.sendPoll();
            Assert.assertTrue((boolean)(thePollResponse instanceof EPPOrgPendActionMsg));
            System.out.println("orgCreatePending: Org Pending Action Response = [" + thePollResponse + "]\n\n");
            this.session.setPollOp("ack");
            this.session.setMsgID(thePollResponse.getMsgQueue().getId());
            thePollResponse = this.session.sendPoll();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("orgCreatePending");
    }

    public void orgDelete() {
        this.printStart("orgDelete");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("orgDelete: Delete res1523.");
            this.org.setTransId("ABC-12345");
            this.org.addOrgId("res1523");
            EPPResponse response = this.org.sendDelete();
            System.out.println("orgDelete: Org Delete Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("orgDelete");
    }

    public void orgUpdate() {
        this.printStart("orgUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("orgUpdate: Update res1523.");
            this.org.setTransId("ABC-12345");
            this.org.addOrgId("res1523");
            this.org.addAddContact(new EPPOrgContact("sh8013", EPPOrgContact.Type.TECHNICAL));
            this.org.addAddRole(new EPPOrgRole("privacyproxy", EPPOrgRoleStatus.clientLinkProhibited, null));
            this.org.addAddStatus(EPPOrgStatus.clientLinkProhibited);
            this.org.addAddContact(new EPPOrgContact("sh8014", EPPOrgContact.Type.BILLING));
            this.org.addAddRole(new EPPOrgRole("reseller"));
            this.org.addRemStatus(EPPOrgStatus.clientDeleteProhibited);
            this.org.setParentId("1523res");
            EPPOrgAddress theAddress = new EPPOrgAddress();
            theAddress.setStreets("124 Example Dr.", "Suite 200");
            theAddress.setCity("Dulles");
            theAddress.setStateProvince("VA");
            theAddress.setPostalCode("20166-6503");
            theAddress.setCountry("US");
            EPPOrgPostalDefinition thePostalDef = new EPPOrgPostalDefinition(EPPOrgPostalDefinition.Type.INT);
            thePostalDef.setAddress(theAddress);
            this.org.addPostalInfo(thePostalDef);
            this.org.setVoice("+1.7034444444");
            EPPResponse response = this.org.sendUpdate();
            System.out.println("orgUpdate: Org Update Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("orgUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.org = new EPPOrg(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

