/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPHello;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLByteArray;
import com.verisign.epp.util.EPPXMLStream;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EPPHttpSession
extends EPPSession {
    private static Logger cat = LoggerFactory.getLogger(EPPHttpSession.class);
    private EPPCodec code = EPPCodec.getInstance();
    private HttpClient httpClient = null;
    private boolean sessionEstablished = false;
    private String url = null;
    private byte[] responsePacket = null;
    private EPPXMLStream xmlStream = null;
    private EPPXMLByteArray byteArray = new EPPXMLByteArray();
    private EPPGreeting greeting = null;
    private EPPSSLContext sslContext;
    private static EPPSendReceiveLogger sendReceiveLogger = EPPEnv.getSendReceiveLogger();

    public EPPHttpSession(String aUrl) throws EPPCommandException {
        this.url = aUrl;
        this.init();
    }

    public EPPHttpSession(String aUrl, EPPSSLContext aSSLContext) throws EPPCommandException {
        this.url = aUrl;
        if (aSSLContext != null) {
            this.sslContext = aSSLContext;
        }
        this.init();
    }

    public EPPHttpSession() throws EPPCommandException {
        this.init();
    }

    private void initSSL() throws EPPCommandException {
        try {
            if (this.url.startsWith("https") && this.sslContext == null) {
                if (this.sslContext != null && this.sslContext.getSslConfig() != null) {
                    cat.debug("EPPHttpSession: Initializing SSL with provided EPPSSLContext");
                    this.sslContext = EPPSSLImpl.initialize(this.sslContext.getSslConfig());
                } else {
                    if (!EPPSSLImpl.isInitialized()) {
                        cat.debug("EPPHttpSession: Initializing SSL with default EPPSSLImpl");
                        EPPSSLImpl.initialize();
                    }
                    this.sslContext = EPPSSLImpl.getEPPSSLContext();
                }
            }
        }
        catch (Exception ex) {
            cat.error("EPPHttpSession.initSSL: Error initializing EPPSSLImpl", (Throwable)ex);
            throw new EPPCommandException("EPPHttpSession.initSSL: Error initializing EPPSSLImpl: " + ex.getMessage());
        }
    }

    @Override
    public void init() throws EPPCommandException {
        try {
            this.url = EPPEnv.getServerName();
        }
        catch (EPPEnvException e) {
            cat.error("Error when trying to get EPP Server Name (URL): ", (Throwable)e);
            throw new EPPCommandException("Error when trying to get EPP Server Name (URL): " + e.getMessage());
        }
        this.initSSL();
        this.initHttpClient();
        this.xmlStream = new EPPXMLStream(EPPSchemaCachingParserPool.getInstance().getPool());
        HttpRequest.Builder theRequestBuilder = HttpRequest.newBuilder();
        try {
            theRequestBuilder.uri(new URI(this.url));
            theRequestBuilder.timeout(Duration.ofMillis(EPPEnv.getReadTimeOut()));
            theRequestBuilder.header("Accept", "application/epp+xml");
            theRequestBuilder.GET();
            HttpRequest theRequest = theRequestBuilder.build();
            cat.info("Connecting to server " + this.url + " using HTTP GET");
            HttpResponse<byte[]> theResponse = this.httpClient.send(theRequest, HttpResponse.BodyHandlers.ofByteArray());
            this.responsePacket = theResponse.body();
        }
        catch (URISyntaxException ex) {
            cat.error("URL is not syntactically correct: " + this.url);
            throw new EPPCommandException("URL is not syntactically correct: " + this.url);
        }
        catch (EPPEnvException ex) {
            cat.error("EPP.ReadTimeOut property not set");
            throw new EPPCommandException("EPP.ReadTimeOut property not set");
        }
        catch (IOException ex) {
            cat.error("Error connecting to server with URL: " + this.url);
            throw new EPPCommandException("Error connecting to server with URL: " + this.url);
        }
        catch (InterruptedException ex) {
            cat.error("InterruptedException connecting to server with URL: " + this.url);
            throw new EPPCommandException("InterruptedException connecting to server with URL: " + this.url);
        }
        if (this.responsePacket == null) {
            cat.error("Response body was null after executing HTTP GET.  Check the URL setting.");
            throw new EPPCommandException("Didn't get response body in response from server when sending initial GET");
        }
        try {
            if (this.byteArray == null) {
                this.byteArray = new EPPXMLByteArray();
            }
            Document theDoc = this.byteArray.decode(this.responsePacket);
            this.greeting = this.codec.decodeGreeting(theDoc);
            sendReceiveLogger.logReceive(this.responsePacket, this.greeting);
        }
        catch (Exception e) {
            e.printStackTrace();
            cat.error("Caught Exception while trying to decode EPPGreeting " + e);
            throw new EPPCommandException("EPPHttpSession.init(): decode Exception: " + e);
        }
        super.initLoginAdapter();
    }

    private void initHttpClient() {
        HttpClient.Builder theBuilder = HttpClient.newBuilder();
        if (EPPSSLImpl.getSSLContext() != null) {
            theBuilder.sslContext(EPPSSLImpl.getSSLContext());
        }
        try {
            theBuilder.connectTimeout(Duration.ofMillis(EPPEnv.getConTimeOut()));
        }
        catch (EPPEnvException e) {
            cat.debug("EPP.ConTimeOut property not set");
        }
        try {
            theBuilder.version(EPPHttpSession.getHttpVersion());
            cat.debug("HTTP Version = " + EPPHttpSession.getHttpVersion());
        }
        catch (EPPEnvException e) {
            cat.error("Exception getting the HTTP version: " + e);
        }
        CookieManager theCookieManager = new CookieManager();
        theBuilder.cookieHandler(theCookieManager);
        this.httpClient = theBuilder.build();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient aHttpClient) {
        if (aHttpClient != null) {
            this.httpClient = aHttpClient;
        }
    }

    public EPPMessage postMessage(EPPMessage aMessage) throws EPPCommandException {
        cat.debug("postMessage() enter");
        EPPMessage theRetMessage = null;
        Document theDoc = null;
        byte[] theMessageXml = null;
        try {
            theDoc = this.codec.encode(aMessage);
            theMessageXml = this.byteArray.encode(theDoc);
        }
        catch (EPPException e) {
            throw new EPPCommandException("Error with postMessage encode : " + e.getMessage());
        }
        HttpRequest.Builder theRequestBuilder = HttpRequest.newBuilder();
        try {
            theRequestBuilder.uri(new URI(this.url));
            theRequestBuilder.timeout(Duration.ofMillis(EPPEnv.getReadTimeOut()));
            theRequestBuilder.header("Content-Type", "application/epp+xml;charset=UTF-8");
            theRequestBuilder.header("Accept-Type", "application/epp+xml");
            theRequestBuilder.POST(HttpRequest.BodyPublishers.ofByteArray(theMessageXml));
            HttpRequest theRequest = theRequestBuilder.build();
            HttpResponse<byte[]> theResponse = this.httpClient.send(theRequest, HttpResponse.BodyHandlers.ofByteArray());
            sendReceiveLogger.logSend(theMessageXml, aMessage);
            this.responsePacket = theResponse.body();
            theDoc = this.byteArray.decode(this.responsePacket);
            theRetMessage = this.codec.decode(theDoc);
            if (theRetMessage instanceof EPPResponse) {
                this.response = (EPPResponse)theRetMessage;
            }
            sendReceiveLogger.logReceive(this.responsePacket, theRetMessage);
        }
        catch (URISyntaxException e) {
            cat.error("URI is invalid:" + this.url);
            throw new EPPCommandException("URI is invalid:" + this.url);
        }
        catch (Exception e) {
            cat.error("Caught Exception while trying to decode response:" + e.getMessage());
            throw new EPPCommandException("Error decoding response: " + e.getMessage());
        }
        cat.debug("postMessage() exit");
        return theRetMessage;
    }

    @Override
    public EPPGreeting hello() throws EPPCommandException {
        cat.debug("hello(): enter");
        EPPHello helloCmd = new EPPHello();
        EPPMessage theRespMsg = this.postMessage(helloCmd);
        if (!(theRespMsg instanceof EPPGreeting)) {
            throw new EPPCommandException("Expected EPPGreeting to Hello Command, but received class " + theRespMsg.getClass().getName());
        }
        this.greeting = (EPPGreeting)theRespMsg;
        cat.debug("hello(): exit");
        return this.greeting;
    }

    @Override
    public EPPResponse sendPoll() throws EPPCommandException {
        EPPMessage theRespMsg;
        cat.debug("sendPoll(): enter");
        EPPPollCmd myCommand = new EPPPollCmd(this.transId, this.pollOp);
        if (this.pollOp.equals("ack")) {
            myCommand.setMsgID(this.msgID);
        }
        if (!((theRespMsg = this.postMessage(myCommand)) instanceof EPPResponse)) {
            throw new EPPCommandException("Expected EPPResponse to Poll Command, but received class " + theRespMsg.getClass().getName());
        }
        if (!this.response.isSuccess()) {
            throw new EPPCommandException("sendPoll() : Error in response from Server ", this.response);
        }
        cat.debug("sendPoll(): exit");
        return this.response;
    }

    @Override
    public void endSession() throws EPPCommandException {
        try {
            this.logout();
        }
        finally {
            try {
                this.endConnection();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void endConnection() throws EPPCommandException {
        cat.debug("endConnection() enter");
        cat.debug("endConnection() exit");
    }

    @Override
    protected void login() throws EPPCommandException {
        cat.debug("login(): enter");
        EPPLoginCmd theLoginCommand = this.setupLoginCommand();
        theLoginCommand = this.newPassword == null ? new EPPLoginCmd(this.transId, this.clientId, this.password) : new EPPLoginCmd(this.transId, this.clientId, this.password, this.newPassword);
        if (this.version != null) {
            theLoginCommand.setVersion(this.version);
        }
        if (this.language != null) {
            theLoginCommand.setLang(this.language);
        }
        theLoginCommand.mergeServicesAndExtensionServices(this.greeting);
        if (this.extensionServices != null) {
            theLoginCommand.setExtensions(this.extensionServices);
        }
        if (this.services != null) {
            theLoginCommand.setServices(this.services);
        }
        if (cat.isDebugEnabled() && !theLoginCommand.isValidServices(this.greeting)) {
            cat.debug("login(EPPGreeting): Login services does not match the greeting services, greeting = [" + this.greeting + "], login = [" + theLoginCommand + "]");
        }
        if (this.loginAdapter != null) {
            cat.debug("login(EPPGreeting): Adapt login command with " + this.loginAdapter.getClass().getName());
            this.loginAdapter.adaptLogin(theLoginCommand, this.greeting);
        } else {
            cat.debug("No login adapter defined");
        }
        EPPMessage theRespMsg = this.postMessage(theLoginCommand);
        if (!(theRespMsg instanceof EPPResponse)) {
            throw new EPPCommandException("Expected EPPResponse to Login Command, but received class " + theRespMsg.getClass().getName());
        }
        if (!this.response.isSuccess()) {
            throw new EPPCommandException("login() : Error in response from Server ", this.response);
        }
        this.validateClientTransId(theLoginCommand, this.response);
        this.sessionEstablished = true;
        this.transId = null;
        cat.debug("login(): exit");
    }

    @Override
    protected void logout() throws EPPCommandException {
        cat.debug("logout(): enter");
        EPPLogoutCmd theLogoutCommand = new EPPLogoutCmd();
        EPPMessage theRespMsg = this.postMessage(theLogoutCommand);
        if (!(theRespMsg instanceof EPPResponse)) {
            throw new EPPCommandException("Expected EPPResponse to Logout Command, but received class " + theRespMsg.getClass().getName());
        }
        if (!this.response.isSuccess()) {
            throw new EPPCommandException("logout() : Error in response from Server ", this.response);
        }
        this.sessionEstablished = false;
        this.transId = null;
        cat.debug("logout(): exit");
    }

    @Override
    public EPPResponse processDocument(EPPCommand aCommand, Class aExpectedResponse) throws EPPCommandException {
        cat.debug("processDocument(): enter");
        Document theDoc = null;
        try {
            theDoc = this.codec.encode(aCommand);
        }
        catch (Exception myException) {
            throw new EPPCommandException("EPPHttpSession.processDocument(): Exception on Command " + myException.getMessage());
        }
        EPPMessage theMessage = this.postMessage(aCommand);
        EPPResponse theResponse = null;
        if (theMessage == null || !(theMessage instanceof EPPResponse)) {
            throw new EPPCommandException("EPPHttpSession.processDocument(): Unexpected post response not being an EPPResponse with " + theMessage);
        }
        theResponse = (EPPResponse)theMessage;
        if (!theResponse.isSuccess()) {
            cat.error("processDocument(): Error in response from Server with error code " + theResponse.getResult().getCode());
            throw new EPPCommandException("EPPHttpSession.processDocument(): Error in response from Server", this.response);
        }
        if (aExpectedResponse != null && !aExpectedResponse.isInstance(theResponse)) {
            cat.error("processDocument(): Unxpected response class " + theResponse.getClass().getName());
            throw new EPPCommandException("EPPHttpSession.processDocument(): .Unexpected response type of " + theResponse.getClass().getName() + ", expecting " + aExpectedResponse);
        }
        super.validateClientTransId(aCommand, theResponse);
        cat.debug("processDocument(): exit");
        return theResponse;
    }

    @Override
    public void sendDocument(Document aDocument, EPPMessage aMessage) throws EPPCommandException {
        throw new EPPCommandException("sendDocument() is not implemented for EPPHttpSession.");
    }

    @Override
    public Document recDocument() throws EPPCommandException {
        throw new EPPCommandException("recDocument() is not implemented for EPPHttpSession.");
    }

    private EPPLoginCmd setupLoginCommand() {
        EPPLoginCmd theLoginCommand = null;
        theLoginCommand = this.newPassword == null ? new EPPLoginCmd(this.transId, this.clientId, this.password) : new EPPLoginCmd(this.transId, this.clientId, this.password, this.newPassword);
        if (this.version != null) {
            theLoginCommand.setVersion(this.version);
        }
        if (this.language != null) {
            theLoginCommand.setLang(this.language);
        }
        if (this.services != null) {
            theLoginCommand.setServices(this.services);
        }
        return theLoginCommand;
    }

    public static HttpClient.Version getHttpVersion() throws EPPEnvException {
        String thePropValue = EPPEnv.getHttpVersion();
        HttpClient.Version theVersion = HttpClient.Version.HTTP_2;
        if (thePropValue != null) {
            switch (thePropValue) {
                case "1.1": {
                    theVersion = HttpClient.Version.HTTP_1_1;
                    break;
                }
                case "2": {
                    theVersion = HttpClient.Version.HTTP_2;
                    break;
                }
                default: {
                    throw new EPPEnvException("Invalid EPP.HttpVersion value of " + thePropValue);
                }
            }
        }
        return theVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    @Override
    public boolean isModeSupported(int aMode) {
        return aMode == 0;
    }

    public EPPGreeting getGreeting() {
        return this.greeting;
    }
}

