/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCheckResp;
import com.verisign.epp.codec.host.EPPHostCheckResult;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPHost;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Enumeration;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPHostTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPHostTst.class);
    private EPPHost host = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testHost() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.hostCheck();
            this.hostInfo();
            this.hostCreate();
            this.hostDelete();
            this.hostUpdate();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void hostCheck() {
        int i;
        EPPHostCheckResp response;
        String myDomainName;
        this.printStart("hostCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostCheck: Check single host name (ns1.example.com)");
            this.host.setTransId("ABC-12345-XYZ");
            myDomainName = this.makeDomainName();
            this.host.addHostName(this.makeHostName(myDomainName));
            response = this.host.sendCheck();
            System.out.println("\nhostCheck: Response = [" + response + "]");
            Assert.assertEquals((long)1L, (long)response.getCheckResults().size());
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                EPPHostCheckResult currResult = response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("hostCheck: Host " + currResult.getName() + " is available");
                    continue;
                }
                System.out.println("hostCheck: Host " + currResult.getName() + " is not available");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostCheck: Check multiple host names (ns1.example.com, ns2.example.com, ns3.example.com)");
            this.host.setTransId("ABC-12345-XYZ");
            myDomainName = this.makeDomainName();
            for (i = 0; i <= 15; ++i) {
                this.host.addHostName(this.makeHostName(myDomainName));
            }
            response = this.host.sendCheck();
            System.out.println("\nhostCheck: Response = [" + response + "]");
            Enumeration<EPPResult> results = response.getResults().elements();
            for (int i2 = 0; i2 < response.getCheckResults().size(); ++i2) {
                EPPHostCheckResult currResult = response.getCheckResults().elementAt(i2);
                if (currResult.isAvailable()) {
                    System.out.println("hostCheck: Host " + currResult.getName() + " is available");
                    continue;
                }
                System.out.println("hostCheck: Host " + currResult.getName() + " is not available");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostCheck");
    }

    public void hostInfo() {
        this.printStart("hostInfo");
        try {
            System.out.println("\nhostInfo: Host info for ns1.example.com");
            this.host.setTransId("ABC-12345-XYZ");
            String myDomainName = this.makeDomainName();
            this.host.addHostName(this.makeHostName(myDomainName));
            EPPHostInfoResp response = this.host.sendInfo();
            System.out.println("hostInfo: Response = [" + response + "]\n\n");
            System.out.println("hostInfo: name = " + response.getName());
            System.out.println("hostInfo: client id = " + response.getClientId());
            System.out.println("hostInfo: created by = " + response.getCreatedBy());
            System.out.println("hostInfo: create date = " + response.getCreatedDate());
            if (response.getAddresses() != null) {
                for (int i = 0; i < response.getAddresses().size(); ++i) {
                    EPPHostAddress currAddress = response.getAddresses().elementAt(i);
                    System.out.print("hostInfo: address " + (i + 1));
                    System.out.print(" name = " + currAddress.getName());
                    if (currAddress.getType() == 0) {
                        System.out.println(", type = IPV4");
                        continue;
                    }
                    if (currAddress.getType() != 0) continue;
                    System.out.println(", type = IPV6");
                }
            }
            if (response.getLastUpdatedBy() != null) {
                System.out.println("hostInfo: last updated by = " + response.getLastUpdatedBy());
            }
            if (response.getLastUpdatedDate() != null) {
                System.out.println("hostInfo: last updated date = " + response.getLastUpdatedDate());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostInfo");
    }

    public void hostCreate() {
        EPPResponse response;
        String myDomainName;
        this.printStart("hostCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostCreate: Create ns1.example.com with no optional attributes");
            this.host.setTransId("ABC-12345-XYZ");
            myDomainName = this.makeDomainName();
            this.host.addHostName(this.makeHostName(myDomainName));
            response = this.host.sendCreate();
            System.out.println("hostCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("hostCreate: Create ns1.example.com with all optional attributes");
            this.host.setTransId("ABC-12345-XYZ");
            myDomainName = this.makeDomainName();
            this.host.addHostName(this.makeHostName(myDomainName));
            this.host.addIPV4Address(this.makeIP());
            this.host.addIPV6Address("1080:0:0:0:8:800:200C:417A");
            this.host.addIPV6Address("::FFFF:129.144.52.38");
            response = this.host.sendCreate();
            System.out.println("hostCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostCreate");
    }

    public void hostDelete() {
        this.printStart("hostDelete");
        try {
            System.out.println("\nhostDelete: Host delete for ns1.example.com");
            this.host.setTransId("ABC-12345-XYZ");
            this.host.addHostName(this.makeHostName(this.makeDomainName()));
            EPPResponse response = this.host.sendDelete();
            System.out.println("hostDelete: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostDelete");
    }

    public void hostUpdate() {
        this.printStart("hostUpdate");
        try {
            System.out.println("\nhostUpdate: Host update for ns1.example.com");
            this.host.setTransId("ABC-12345-XYZ");
            this.host.addHostName(this.makeHostName(this.makeDomainName()));
            this.host.addIPV4Address(this.makeIP());
            this.host.removeIPV6Address("1080:0:0:0:8:800:200C:417A");
            this.host.addStatus("ok", "Hello_World", "en");
            this.host.removeStatus("ok", "Hello World with spaces", "en");
            EPPResponse response = this.host.sendUpdate();
            System.out.println("hostUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("hostUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.host = new EPPHost(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(EPPCommandException aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = aException.getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

