/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.host.EPPHostAddRemove;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCheckCmd;
import com.verisign.epp.codec.host.EPPHostCheckResp;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostDeleteCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.host.EPPHostStatus;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Vector;

public class EPPHost {
    public static final String STAT_OK = "ok";
    public static final String STAT_PENDING_DELETE = "pendingDelete";
    public static final String STAT_PENDING_TRANSFER = "pendingTransfer";
    public static final String STAT_PENDING_CREATE = "pendingCreate";
    public static final String STAT_PENDING_UPDATE = "pendingUpdate";
    public static final String STAT_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String STAT_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STAT_LINKED = "linked";
    public static final String STAT_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STAT_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String DEFAULT_LANG = "en";
    private Vector<String> hosts = new Vector();
    private Vector<EPPHostAddress> addAddresses = null;
    private Vector<EPPHostAddress> removeAddresses = null;
    private Vector<EPPHostStatus> addStatuses = null;
    private Vector<EPPHostStatus> removeStatuses = null;
    private String newName = null;
    private EPPSession session = null;
    private String transId = null;
    private Vector<EPPCodecComponent> extensions = null;

    public EPPHost(EPPSession newSession) {
        this.session = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    @Deprecated
    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector<EPPCodecComponent> aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector<EPPCodecComponent> getExtensions() {
        return this.extensions;
    }

    public void addHostName(String newHostName) {
        this.hosts.addElement(newHostName);
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String aNewName) {
        this.newName = aNewName;
    }

    public void addIPV4Address(String newIPV4Address) {
        if (this.addAddresses == null) {
            this.addAddresses = new Vector();
        }
        this.addAddresses.addElement(new EPPHostAddress(newIPV4Address));
    }

    public void removeIPV4Address(String newIPV4Address) {
        if (this.removeAddresses == null) {
            this.removeAddresses = new Vector();
        }
        this.removeAddresses.addElement(new EPPHostAddress(newIPV4Address));
    }

    public void addIPV6Address(String newIPV6Address) {
        if (this.addAddresses == null) {
            this.addAddresses = new Vector();
        }
        this.addAddresses.addElement(new EPPHostAddress(newIPV6Address, 1));
    }

    public void removeIPV6Address(String newIPV6Address) {
        if (this.removeAddresses == null) {
            this.removeAddresses = new Vector();
        }
        this.removeAddresses.addElement(new EPPHostAddress(newIPV6Address, 1));
    }

    public void addStatus(String aStatus) {
        if (this.addStatuses == null) {
            this.addStatuses = new Vector();
        }
        this.addStatuses.addElement(new EPPHostStatus(aStatus));
    }

    public void removeStatus(String aStatus) {
        if (this.removeStatuses == null) {
            this.removeStatuses = new Vector();
        }
        this.removeStatuses.addElement(new EPPHostStatus(aStatus));
    }

    public void addStatus(String aStatus, String aDesc, String aLang) {
        if (this.addStatuses == null) {
            this.addStatuses = new Vector();
        }
        this.addStatuses.addElement(new EPPHostStatus(aStatus, aDesc, aLang));
    }

    public void removeStatus(String aStatus, String aDesc, String aLang) {
        if (this.removeStatuses == null) {
            this.removeStatuses = new Vector();
        }
        this.removeStatuses.addElement(new EPPHostStatus(aStatus, aDesc, aLang));
    }

    public void setTransId(String newTransId) {
        this.transId = newTransId;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }

    public EPPResponse sendCreate() throws EPPCommandException {
        if (this.hosts.size() != 1) {
            throw new EPPCommandException("One Host Name is required for sendCreate()");
        }
        EPPHostCreateCmd theCommand = new EPPHostCreateCmd(this.transId, this.hosts.firstElement(), this.addAddresses);
        theCommand.setExtensions(this.extensions);
        this.resetHost();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPHostCheckResp sendCheck() throws EPPCommandException {
        if (this.hosts.size() == 0) {
            throw new EPPCommandException("At least One Host Name is required for sendCheck()");
        }
        EPPHostCheckCmd theCommand = new EPPHostCheckCmd(this.transId, this.hosts);
        theCommand.setExtensions(this.extensions);
        this.resetHost();
        return (EPPHostCheckResp)this.session.processDocument(theCommand, EPPHostCheckResp.class);
    }

    public EPPHostInfoResp sendInfo() throws EPPCommandException {
        if (this.hosts.size() != 1) {
            throw new EPPCommandException("One Host Name is required for sendInfo()");
        }
        EPPHostInfoCmd theCommand = new EPPHostInfoCmd(this.transId, this.hosts.firstElement());
        theCommand.setExtensions(this.extensions);
        this.resetHost();
        return (EPPHostInfoResp)this.session.processDocument(theCommand, EPPHostInfoResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.hosts.size() != 1) {
            throw new EPPCommandException("One Host Name is required for sendUpdate()");
        }
        EPPHostAddRemove addItems = null;
        if (this.addAddresses != null || this.addStatuses != null) {
            addItems = new EPPHostAddRemove(this.addAddresses, this.addStatuses);
        }
        EPPHostAddRemove removeItems = null;
        if (this.removeAddresses != null || this.removeStatuses != null) {
            removeItems = new EPPHostAddRemove(this.removeAddresses, this.removeStatuses);
        }
        EPPHostAddRemove changeItems = null;
        if (this.newName != null) {
            changeItems = new EPPHostAddRemove(this.newName);
        }
        EPPHostUpdateCmd theCommand = new EPPHostUpdateCmd(this.transId, this.hosts.firstElement(), addItems, removeItems, changeItems);
        theCommand.setExtensions(this.extensions);
        this.resetHost();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.hosts.size() != 1) {
            throw new EPPCommandException("One Host Name is required for sendDelete()");
        }
        EPPHostDeleteCmd theCommand = new EPPHostDeleteCmd(this.transId, this.hosts.firstElement());
        theCommand.setExtensions(this.extensions);
        this.resetHost();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    protected void resetHost() {
        this.hosts = new Vector();
        this.addAddresses = null;
        this.removeAddresses = null;
        this.addStatuses = null;
        this.removeStatuses = null;
        this.transId = null;
        this.extensions = null;
        this.newName = null;
    }
}

