/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCheckResult;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPContact;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPContactTst {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPContactTst.class);
    private EPPContact contact = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    @Test
    public void testContact() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.contactCheck();
            this.contactCreate();
            this.contactInfo();
            this.contactUpdate();
            this.contactTransfer();
            this.contactDelete();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    private void contactCheck() {
        int i;
        EPPContactCheckResp response;
        this.printStart("contactCheck");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCheck: Check single contact id " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            response = this.contact.sendCheck();
            System.out.println("\ncontactCheck: Response = [" + response + "]");
            for (i = 0; i < response.getCheckResults().size(); ++i) {
                EPPContactCheckResult currResult = (EPPContactCheckResult)response.getCheckResults().elementAt(i);
                if (currResult.isAvailable()) {
                    System.out.println("contactCheck: Contact " + currResult.getId() + " is available");
                    continue;
                }
                System.out.println("contactCheck: Contact " + currResult.getId() + " is unavailable");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCheck: Check multiple contact ids");
            this.contact.setTransId("ABC-12345-XYZ");
            for (i = 0; i <= 20; ++i) {
                this.contact.addContactId(this.makeContactName());
            }
            response = this.contact.sendCheck();
            System.out.println("\ncontactCheck: Response = [" + response + "]");
            Enumeration<EPPResult> results = response.getResults().elements();
            for (int i2 = 0; i2 < response.getCheckResults().size(); ++i2) {
                EPPContactCheckResult currResult = (EPPContactCheckResult)response.getCheckResults().elementAt(i2);
                if (currResult.isAvailable()) {
                    System.out.println("contactCheck: Contact " + currResult.getId() + " is available");
                    continue;
                }
                System.out.println("contactCheck: Contact " + currResult.getId() + " is unavailable");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactCheck");
    }

    public void contactInfo() {
        this.printStart("contactInfo");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo: Contact info for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            EPPContactInfoResp response = this.contact.sendInfo();
            System.out.println("contactInfo: Response = [" + response + "]\n\n");
            System.out.println("contactInfo: id = " + response.getId());
            Vector postalContacts = null;
            if (response.getPostalInfo().size() > 0) {
                postalContacts = response.getPostalInfo();
                for (int j = 0; j < postalContacts.size(); ++j) {
                    System.out.println("contactInfo:\t\tname = " + ((EPPContactPostalDefinition)postalContacts.elementAt(j)).getName());
                    System.out.println("contactInfo:\t\torganization = " + ((EPPContactPostalDefinition)postalContacts.elementAt(j)).getOrg());
                    EPPContactAddress address = ((EPPContactPostalDefinition)postalContacts.elementAt(j)).getAddress();
                    for (int i = 0; i < address.getStreets().size(); ++i) {
                        System.out.println("contactInfo:\t\tstreet" + (i + 1) + " = " + address.getStreets().elementAt(i));
                    }
                    System.out.println("contactInfo:\t\tcity = " + address.getCity());
                    System.out.println("contactInfo:\t\tstate province = " + address.getStateProvince());
                    System.out.println("contactInfo:\t\tpostal code = " + address.getPostalCode());
                    System.out.println("contactInfo:\t\tcountry = " + address.getCountry());
                }
            }
            System.out.println("contactInfo:\temail = " + response.getEmail());
            System.out.println("contactInfo:\tvoice = " + response.getVoice());
            System.out.println("contactInfo:\tvoice ext = " + response.getVoiceExt());
            System.out.println("contactInfo:\tfax = " + response.getFax());
            System.out.println("contactInfo:\tfax ext = " + response.getFaxExt());
            System.out.println("contactInfo: client id = " + response.getClientId());
            System.out.println("contactInfo: created by = " + response.getCreatedBy());
            System.out.println("contactInfo: create date = " + response.getCreatedDate());
            if (response.getFax() != null) {
                System.out.println("contactInfo:\tfax = " + response.getFax());
            }
            if (response.getVoice() != null) {
                System.out.println("contactInfo:\tVoice = " + response.getVoice());
            }
            if (response.getLastUpdatedBy() != null) {
                System.out.println("contactInfo: last updated by = " + response.getLastUpdatedBy());
            }
            if (response.getLastUpdatedDate() != null) {
                System.out.println("contactInfo: last updated date = " + response.getLastUpdatedDate());
            }
            if (response.getLastTransferDate() != null) {
                System.out.println("contactInfo: last updated date = " + response.getLastTransferDate());
            }
            if (response.getAuthInfo() != null) {
                System.out.println("contactInfo: authorization info = " + response.getAuthInfo().getPassword());
            }
            if (response.getDisclose() != null) {
                System.out.println("contactInfo: disclose info = " + response.getDisclose());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactInfo");
    }

    public void contactCreate() {
        this.printStart("contactCreate");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreate: Contact create for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("123");
            this.contact.setFaxNumber("+1.7035555556");
            this.contact.setFaxExt("456");
            this.contact.setEmail("jdoe@example.com");
            Vector<String> streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            streets.addElement("This is third line");
            EPPContactAddress address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            EPPContactPostalDefinition name = new EPPContactPostalDefinition("loc");
            name.setName("John Doe");
            name.setOrg("Example Inc.");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            EPPContactAddress Intaddress = new EPPContactAddress();
            Intaddress.setStreets(streets);
            Intaddress.setCity("Dulles");
            Intaddress.setStateProvince("VA");
            Intaddress.setPostalCode("20166-6503");
            Intaddress.setCountry("US");
            EPPContactPostalDefinition Intname = new EPPContactPostalDefinition("int");
            Intname.setName("John Doe");
            Intname.setOrg("Example Inc.");
            Intname.setAddress(Intaddress);
            this.contact.addPostalInfo(Intname);
            EPPContactDisclose disclose = new EPPContactDisclose();
            disclose.setFlag(false);
            disclose.setNameInt(true);
            disclose.setNameLoc(true);
            disclose.setOrgInt(true);
            disclose.setOrgLoc(true);
            disclose.setAddrInt(true);
            disclose.setAddrLoc(true);
            disclose.setVoice(false);
            disclose.setFax(false);
            disclose.setEmail(false);
            this.contact.setDisclose(disclose);
            EPPResponse response = this.contact.sendCreate();
            System.out.println("contactCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactCreate");
    }

    public void contactDelete() {
        this.printStart("contactDelete");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactDelete: Contact delete for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            EPPResponse response = this.contact.sendDelete();
            System.out.println("contactDelete: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactDelete");
    }

    public void contactUpdate() {
        this.printStart("contactUpdate");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactUpdate: Contact update for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            Vector<String> streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            streets.addElement("This is third line");
            EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
            EPPContactPostalDefinition postal = new EPPContactPostalDefinition("Joe Brown", "Example Corp.", "loc", address);
            this.contact.addStatus("pendingDelete");
            this.contact.addPostalInfo(postal);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("456");
            this.contact.setFaxNumber("+1.7035555555");
            this.contact.setFaxExt("789");
            this.contact.setAuthorizationId("ClientXYZ");
            EPPContactDisclose disclose = new EPPContactDisclose();
            disclose.setFlag(false);
            disclose.setNameInt(true);
            disclose.setNameLoc(true);
            disclose.setOrgInt(true);
            disclose.setOrgLoc(true);
            disclose.setAddrInt(true);
            disclose.setAddrLoc(true);
            disclose.setVoice(false);
            disclose.setFax(false);
            disclose.setEmail(false);
            this.contact.setDisclose(disclose);
            EPPResponse response = this.contact.sendUpdate();
            System.out.println("contactUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactUpdate");
    }

    public void contactTransfer() {
        EPPContactTransferResp response;
        this.printStart("contactTransfer");
        String theName = this.makeContactName();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactTransfer: Contact transfer request for " + theName);
            this.contact.setTransferOpCode("request");
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientX");
            this.contact.addContactId(this.makeContactName());
            response = this.contact.sendTransfer();
            System.out.println("contactTransfer: Response = [" + response + "]\n\n");
            System.out.println("contactTransfer: id = " + response.getId());
            System.out.println("contactTransfer: request client = " + response.getRequestClient());
            System.out.println("contactTransfer: action client = " + response.getActionClient());
            System.out.println("contactTransfer: transfer status = " + response.getTransferStatus());
            System.out.println("contactTransfer: request date = " + response.getRequestDate());
            System.out.println("contactTransfer: action date = " + response.getActionDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactTransfer: Contact transfer query for " + theName);
            this.contact.setTransferOpCode("query");
            this.contact.addContactId(this.makeContactName());
            response = this.contact.sendTransfer();
            System.out.println("contactTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactTransfer: Contact transfer cancel for " + theName);
            this.contact.setTransferOpCode("cancel");
            this.contact.addContactId(this.makeContactName());
            response = this.contact.sendTransfer();
            System.out.println("contactTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactTransfer: Contact transfer reject for " + theName);
            this.contact.setTransferOpCode("reject");
            this.contact.addContactId(this.makeContactName());
            response = this.contact.sendTransfer();
            System.out.println("contactTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactTransfer: Contact transfer approve for " + theName);
            this.contact.setTransferOpCode("approve");
            this.contact.addContactId(this.makeContactName());
            response = this.contact.sendTransfer();
            System.out.println("contactTransfer: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            EPPResponse pollResponse;
            do {
                this.session.setTransId("CONTACT-POLL");
                this.session.setPollOp("req");
                pollResponse = this.session.sendPoll();
                System.out.println("contactTransfer: Poll Response = [" + pollResponse + "]\n\n");
                if (pollResponse.getResult().getCode() != 1301) continue;
                this.session.setPollOp("ack");
                this.session.setMsgID(pollResponse.getMsgQueue().getId());
                EPPResponse pollAckResponse = this.session.sendPoll();
                System.out.println("contactTransfer: Poll Ack Response = [" + pollAckResponse + "]\n\n");
            } while (pollResponse.getResult().getCode() == 1301);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactTransfer");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.contact = new EPPContact(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(EPPCommandException aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = aException.getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

