/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPContact;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPContactRelaxedValidationTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPContactRelaxedValidationTst.class);
    private EPPContact contact = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPContactRelaxedValidationTst(String name) {
        super(name);
    }

    public void testContact() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.contactCreateMinimal();
            this.contactCreatePartial();
            this.contactCreateWithAllAttributes();
            this.contactInfo("Minimal");
            this.contactInfo("Partial");
            this.contactInfo("Default");
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void contactInfo(String aPrefix) {
        this.printStart("contactInfo - " + aPrefix);
        String theName = this.makeContactId(aPrefix);
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("\ncontactInfo - " + aPrefix + ": Contact info for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.addContactId(theName);
            EPPContactInfoResp response = this.contact.sendInfo();
            System.out.println("contactInfo - " + aPrefix + ": Response = [" + response + "]\n\n");
            System.out.println("contactInfo - " + aPrefix + ": id = " + response.getId());
            Vector postalContacts = null;
            if (response.getPostalInfo().size() > 0) {
                postalContacts = response.getPostalInfo();
                for (int j = 0; j < postalContacts.size(); ++j) {
                    EPPContactPostalDefinition postalInfo = (EPPContactPostalDefinition)postalContacts.elementAt(j);
                    System.out.println("contactInfo - " + aPrefix + ":\t\tpostal info type = " + postalInfo.getType());
                    System.out.println("contactInfo - " + aPrefix + ":\t\tname = " + postalInfo.getName());
                    System.out.println("contactInfo - " + aPrefix + ":\t\torganization = " + postalInfo.getOrg());
                    if (postalInfo.hasAddress()) {
                        EPPContactAddress address = postalInfo.getAddress();
                        if (address.hasStreets()) {
                            for (int i = 0; i < address.getStreets().size(); ++i) {
                                System.out.println("contactInfo - " + aPrefix + ":\t\tstreet" + (i + 1) + " = " + address.getStreets().elementAt(i));
                            }
                        } else {
                            System.out.println("contactInfo - " + aPrefix + ":\t\tstreets = null");
                        }
                        System.out.println("contactInfo - " + aPrefix + ":\t\tcity = " + address.getCity());
                        System.out.println("contactInfo - " + aPrefix + ":\t\tstate province = " + address.getStateProvince());
                        System.out.println("contactInfo - " + aPrefix + ":\t\tpostal code = " + address.getPostalCode());
                        System.out.println("contactInfo - " + aPrefix + ":\t\tcountry = " + address.getCountry());
                        continue;
                    }
                    System.out.println("contactInfo - " + aPrefix + ":\t\taddress = null");
                }
            }
            System.out.println("contactInfo - " + aPrefix + ":\temail = " + response.getEmail());
            System.out.println("contactInfo - " + aPrefix + ":\tvoice = " + response.getVoice());
            System.out.println("contactInfo - " + aPrefix + ":\tvoice ext = " + response.getVoiceExt());
            System.out.println("contactInfo - " + aPrefix + ":\tfax = " + response.getFax());
            System.out.println("contactInfo - " + aPrefix + ":\tfax ext = " + response.getFaxExt());
            System.out.println("contactInfo - " + aPrefix + ": client id = " + response.getClientId());
            System.out.println("contactInfo - " + aPrefix + ": created by = " + response.getCreatedBy());
            System.out.println("contactInfo - " + aPrefix + ": create date = " + response.getCreatedDate());
            System.out.println("contactInfo - " + aPrefix + ": last updated by = " + response.getLastUpdatedBy());
            System.out.println("contactInfo - " + aPrefix + ": last updated date = " + response.getLastUpdatedDate());
            System.out.println("contactInfo - " + aPrefix + ": last transfer date = " + response.getLastTransferDate());
            if (response.hasAuthInfo()) {
                System.out.println("contactInfo - " + aPrefix + ": authorization info = " + response.getAuthInfo().getPassword());
            } else {
                System.out.println("contactInfo - " + aPrefix + ": authorization info = null");
            }
            if (response.hasDisclose()) {
                System.out.println("contactInfo - " + aPrefix + ": disclose info = " + response.getDisclose());
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactInfo - " + aPrefix);
    }

    public void contactCreateMinimal() {
        this.printStart("contactCreateMinimal");
        String theName = this.makeContactId();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreateMinimal: Contact create for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            EPPContactPostalDefinition postalInfo = new EPPContactPostalDefinition("int");
            this.contact.addPostalInfo(postalInfo);
            EPPResponse response = this.contact.sendCreate();
            System.out.println(String.format("contactCreateMinimal: Response = [%s]\n\n", response));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactCreateMinimal");
    }

    public void contactCreatePartial() {
        this.printStart("contactCreatePartial");
        String theName = this.makeContactId();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreatePartial: Contact create for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            EPPContactPostalDefinition postalInfo = new EPPContactPostalDefinition("int");
            EPPContactAddress address = new EPPContactAddress();
            address.setCountry("US");
            postalInfo.setAddress(address);
            this.contact.addPostalInfo(postalInfo);
            this.contact.setEmail("jdoe@example.com");
            EPPResponse response = this.contact.sendCreate();
            System.out.println(String.format("contactCreatePartial: Response = [%s]\n\n", response));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactCreatePartial");
    }

    public void contactCreateWithAllAttributes() {
        this.printStart("contactCreateWithAllAttributes");
        String theName = this.makeContactId();
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("contactCreateWithAllAttributes: Contact create for " + theName);
            this.contact.setTransId("ABC-12345-XYZ");
            this.contact.setAuthorizationId("ClientXYZ");
            this.contact.addContactId(theName);
            this.contact.setVoicePhone("+1.7035555555");
            this.contact.setVoiceExt("123");
            this.contact.setFaxNumber("+1.7035555556");
            this.contact.setFaxExt("456");
            this.contact.setEmail("jdoe@example.com");
            Vector<String> streets = new Vector<String>();
            streets.addElement("123 Example Dr.");
            streets.addElement("Suite 100");
            streets.addElement("This is third line");
            EPPContactAddress address = new EPPContactAddress();
            address.setStreets(streets);
            address.setCity("Dulles");
            address.setStateProvince("VA");
            address.setPostalCode("20166-6503");
            address.setCountry("US");
            EPPContactPostalDefinition name = new EPPContactPostalDefinition("loc");
            name.setName("John Doe");
            name.setOrg("Example Inc.");
            name.setAddress(address);
            this.contact.addPostalInfo(name);
            EPPContactAddress Intaddress = new EPPContactAddress();
            Intaddress.setStreets(streets);
            Intaddress.setCity("Dulles");
            Intaddress.setStateProvince("VA");
            Intaddress.setPostalCode("20166-6503");
            Intaddress.setCountry("US");
            EPPContactPostalDefinition Intname = new EPPContactPostalDefinition("int");
            Intname.setName("John Doe");
            Intname.setOrg("Example Inc.");
            Intname.setAddress(Intaddress);
            this.contact.addPostalInfo(Intname);
            EPPContactDisclose disclose = new EPPContactDisclose();
            disclose.setFlag(false);
            disclose.setNameInt(true);
            disclose.setNameLoc(true);
            disclose.setOrgInt(true);
            disclose.setOrgLoc(true);
            disclose.setAddrInt(true);
            disclose.setAddrLoc(true);
            disclose.setVoice(false);
            disclose.setFax(false);
            disclose.setEmail(false);
            this.contact.setDisclose(disclose);
            EPPResponse response = this.contact.sendCreate();
            System.out.println("contactCreateWithAllAttributes: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("contactCreateWithAllAttributes");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.contact = new EPPContact(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPContactRelaxedValidationTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        if (!EPPEnv.isContactRelaxedValidation()) {
            System.out.println(EPPContactRelaxedValidationTst.class.getName() + " skipped due to EPP.Contact.RelaxedValidation property != \"true\"");
            return new TestSuite();
        }
        return suite;
    }

    public void handleException(EPPCommandException aException) {
        EPPResponse theResponse = null;
        if (aException instanceof EPPCommandException) {
            theResponse = aException.getResponse();
        }
        aException.printStackTrace();
        if (theResponse != null && !theResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + theResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    private String makeContactId(String aPrefix) {
        long tm = System.currentTimeMillis();
        if (aPrefix != null && !aPrefix.isEmpty()) {
            return new String(aPrefix + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
        }
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private String makeContactId() {
        return this.makeContactId("");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }

    private boolean runTestsForRelaxedValidations() {
        return EPPEnv.isContactRelaxedValidation();
    }
}

