/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.coaext.EPPCoaExtCreate;
import com.verisign.epp.codec.coaext.EPPCoaExtInfData;
import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.coaext.EPPCoaExtUpdate;
import com.verisign.epp.codec.coaext.EPPCoaExtValue;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPCoaDomainTst {
    private EPPDomain domain = null;
    private EPPSession session = null;
    private int iteration = 0;
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private Random rd = new Random(System.currentTimeMillis());
    private static Logger cat = LoggerFactory.getLogger(EPPCoaDomainTst.class);

    @Test
    public void testCoa() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.coaCreate();
            this.coaFullInfoOwnedDomain();
            this.coaFullInfoNotOwnedDomain();
            this.coaPartialInfo();
            this.coaUpdatePut();
            this.coaUpdateRem();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void coaCreate() {
        this.printStart("coaCreate");
        try {
            System.out.println("coaCreate: Domain Create");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ClientX");
            EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
            EPPCoaExtValue value = new EPPCoaExtValue("value1");
            EPPCoaExtAttr attr = new EPPCoaExtAttr();
            attr.setKey(key);
            attr.setValue(value);
            EPPCoaExtCreate create = new EPPCoaExtCreate();
            create.appendAttr(attr);
            this.domain.addExtension(create);
            EPPDomainCreateResp domainResponse = this.domain.sendCreate();
            System.out.println("coaCreate: Response = [" + domainResponse + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("coaCreate");
    }

    public void coaUpdateRem() {
        this.printStart("coaUpdateRem");
        try {
            System.out.println("coaUpdateRem: Domain Update");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ClientX");
            EPPCoaExtUpdate updateRem = new EPPCoaExtUpdate();
            EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
            updateRem.appendRemAttr(key);
            this.domain.addExtension(updateRem);
            EPPResponse domainResponse = this.domain.sendUpdate();
            System.out.println("coaUpdateRem: Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPCoaExtUpdate.class)) {
                Assert.fail((String)"Unexpected EPPCoaExtUpdate returned in response.");
            } else {
                System.out.println("coaUpdateRem: Response has no extension, which is correct.");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("coaUpdateRem");
    }

    public void coaUpdatePut() {
        this.printStart("coaUpdateAdd");
        try {
            System.out.println("coaUpdateAdd: Domain Update");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setAuthString("ClientX");
            EPPCoaExtUpdate updateAdd = new EPPCoaExtUpdate();
            EPPCoaExtAttr attr = new EPPCoaExtAttr();
            EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
            EPPCoaExtValue value = new EPPCoaExtValue("value1");
            attr.setKey(key);
            attr.setValue(value);
            updateAdd.appendPutAttr(attr);
            this.domain.addExtension(updateAdd);
            EPPResponse domainResponse = this.domain.sendUpdate();
            System.out.println("coaUpdateAdd: Response = [" + domainResponse + "]\n\n");
            if (domainResponse.hasExtension(EPPCoaExtCreate.class)) {
                Assert.fail((String)"Coa Create extension included in create response.");
            } else {
                System.out.println("coaUpdateAdd: Response has no extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("coaUpdateAdd");
    }

    public void coaFullInfoOwnedDomain() {
        this.printStart("EPPCoaDomainTst coaFullInfoOwnedDomain");
        try {
            System.out.println("\ntestDomainInfo: Domain info of full-info-owned.com");
            this.domain.addDomainName("coa-full-info-owned.com");
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPCoaExtInfData.class)) {
                EPPCoaExtInfData coaInfData = (EPPCoaExtInfData)response.getExtension(EPPCoaExtInfData.class);
                Assert.assertEquals((long)1L, (long)coaInfData.getAttrs().size());
                for (Object attrObject : coaInfData.getAttrs()) {
                    if (attrObject == null) continue;
                    EPPCoaExtAttr attr = (EPPCoaExtAttr)attrObject;
                    Assert.assertNotNull((Object)attr.getKey());
                    Assert.assertNotNull((Object)attr.getValue());
                }
            } else {
                Assert.fail((String)"EPPcoaExtInfData extension not included for domain info of full-info-owned.com");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("EPPSecDNSDomainTst coaFullInfoOwnedDomain");
    }

    public void coaFullInfoNotOwnedDomain() {
        this.printStart("EPPCoaDomainTst coaFullInfoNotOwnedDomain");
        try {
            System.out.println("\ntestDomainInfo: Domain info of full-info-not-owned.com");
            this.domain.addDomainName("full-info-not-owned.com");
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPCoaExtInfData.class)) {
                Assert.fail((String)"EPPCoaExtInfData extension should not be included for domain info of full-info-not-owned.com");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("EPPSecDNSDomainTst coaFullInfoNotOwnedDomain");
    }

    public void coaPartialInfo() {
        this.printStart("EPPCoaDomainTst coaPartialInfo");
        try {
            System.out.println("\ntestDomainInfo: Domain info of partial-info.com");
            this.domain.addDomainName("partial-info.com");
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPCoaExtInfData.class)) {
                Assert.fail((String)"EPPCoaExtInfData extension should not be included for domain info of partial-info.com");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("EPPSecDNSDomainTst coaPartialInfo");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    @Before
    public void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    @After
    public void tearDown() {
        this.endSession();
    }

    @BeforeClass
    public static void beforeClass() {
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
    }

    public void handleException(Exception aException) {
        EPPResponse domainResponse = this.session.getResponse();
        aException.printStackTrace();
        if (domainResponse != null && !domainResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + domainResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".second.name");
    }

    public String makeEmail() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + "@second.name");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

