/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPComponentNotFoundException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPByteArrayAssembler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.pool.transformer.EPPTransformerPool;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLByteArray;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class HttpEPPXMLAssembler
implements EPPByteArrayAssembler {
    private static boolean poolsInitialized = false;
    private static Logger LOG = LoggerFactory.getLogger(HttpEPPXMLAssembler.class);
    private static EPPSendReceiveLogger sendReceiveLogger;
    private EPPCodec codec = EPPCodec.getInstance();

    public HttpEPPXMLAssembler() {
        this.initXmlPools();
        sendReceiveLogger = EPPEnv.getSendReceiveLogger();
    }

    private void initXmlPools() {
        if (!poolsInitialized) {
            EPPSchemaCachingParserPool.getInstance();
            EPPTransformerPool.getInstance();
            poolsInitialized = true;
        }
    }

    @Override
    public EPPEvent decode(byte[] aBytes, Object aData) throws EPPAssemblerException {
        LOG.debug("decode(): Enter");
        SessionData theSessionData = (SessionData)aData;
        EPPMessage theMessage = null;
        try {
            EPPXMLByteArray xmlByteArray = new EPPXMLByteArray(EPPSchemaCachingParserPool.getInstance().getPool(), EPPTransformerPool.getInstance().getPool());
            Document domDocument = xmlByteArray.decode(aBytes);
            theMessage = this.codec.decode(domDocument);
            theSessionData.setMessage(theMessage);
        }
        catch (EPPComponentNotFoundException e) {
            LOG.debug("decode():", (Throwable)e);
            switch (e.getKind()) {
                case 1: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.COMMANDNOTFOUND);
                }
                case 3: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.EXTENSIONNOTFOUND);
                }
                case 2: {
                    throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.RESPONSENOTFOUND);
                }
            }
        }
        catch (EPPDecodeException e) {
            LOG.debug("decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPAssemblerException e) {
            LOG.debug("decode():", (Throwable)e);
            throw e;
        }
        catch (EPPException e) {
            LOG.debug("decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.XML);
        }
        catch (InterruptedIOException e) {
            LOG.debug("decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.INTRUPTEDIO);
        }
        catch (IOException e) {
            LOG.debug("decode():", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.CLOSECON);
        }
        LOG.debug("decode(): Return");
        return new EPPEvent(theMessage);
    }

    @Override
    public byte[] encode(EPPEventResponse aResponse, Object aData) throws EPPAssemblerException {
        LOG.debug("encode(): Enter");
        byte[] eppPacket = null;
        try {
            EPPMessage response = aResponse.getResponse();
            Document domDocument = this.codec.encode(response);
            EPPXMLByteArray xmlByteArray = new EPPXMLByteArray(EPPSchemaCachingParserPool.getInstance().getPool(), EPPTransformerPool.getInstance().getPool());
            eppPacket = xmlByteArray.encode(domDocument);
        }
        catch (EPPEncodeException e) {
            LOG.debug("encode()", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.MISSINGPARAMETER);
        }
        catch (EPPException e) {
            LOG.debug("encode()", (Throwable)e);
            throw new EPPAssemblerException(e.getMessage(), EPPAssemblerException.FATAL);
        }
        LOG.debug("encode(): Return");
        return eppPacket;
    }
}

