/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchDeleteCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchMapFactory;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPNameWatchHandler
implements EPPEventHandler {
    private static final String NS = "http://www.nic.name/epp/nameWatch-1.0";
    private static Logger cat = LoggerFactory.getLogger(EPPNameWatchHandler.class);

    public EPPNameWatchHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPNameWatchMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error("Couldn't load the Map Factory associated with the NameWatch Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public final String getNamespace() {
        return NS;
    }

    @Override
    public final EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        EPPEventResponse response;
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (message instanceof EPPNameWatchCreateCmd) {
            response = this.doNameWatchCreate(aEvent, aData);
        } else if (message instanceof EPPNameWatchDeleteCmd) {
            response = this.doNameWatchDelete(aEvent, aData);
        } else if (message instanceof EPPNameWatchInfoCmd) {
            response = this.doNameWatchInfo(aEvent, aData);
        } else if (message instanceof EPPNameWatchRenewCmd) {
            response = this.doNameWatchRenew(aEvent, aData);
        } else if (message instanceof EPPNameWatchTransferCmd) {
            response = this.doNameWatchTransfer(aEvent, aData);
        } else if (message instanceof EPPNameWatchUpdateCmd) {
            response = this.doNameWatchUpdate(aEvent, aData);
        } else {
            throw new EPPEventException("In EPPNameWatchHandler an event was sent that is not supported");
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doNameWatchCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameWatchDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameWatchInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameWatchRenew(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameWatchTransfer(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameWatchUpdate(EPPEvent var1, Object var2);
}

