/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.framework.EPPAssembler;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPConnectionHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPDispatcher {
    private static final EPPDispatcher instance = new EPPDispatcher();
    private static Logger cat = LoggerFactory.getLogger(EPPDispatcher.class);
    private Hashtable eventHandlers = new Hashtable();
    private EPPAssembler assembler;
    private EPPConnectionHandler connectionHandler;

    private EPPDispatcher() {
    }

    public static EPPDispatcher getInstance() {
        return instance;
    }

    public void processConnection(InputStream aInputStream, OutputStream aOutputStream, Object aData) {
        cat.debug("processConnection(InputStream, OutputStream, Object): Enter");
        try {
            EPPEventResponse greeting = this.connectionHandler.handleConnection(aData);
            this.assembler.toStream(greeting, aOutputStream, aData);
        }
        catch (EPPAssemblerException e) {
            cat.error("processConnection(InputStream, OutputStream, Object)", (Throwable)e);
        }
        catch (NullPointerException e) {
            cat.error("processConnection(InputStream, OutputStream, Object)", (Throwable)e);
        }
        cat.debug("processConnection(InputStream, OutputStream, Object): Return");
    }

    public void setAssembler(EPPAssembler aAssembler) {
        this.assembler = aAssembler;
    }

    public void processMessage(InputStream aInputStream, OutputStream aOutputStream, Object aData) throws EPPEventException, EPPAssemblerException {
        cat.debug("processMessage(InputStream, OutputStream, Object): Enter");
        if (this.assembler == null) {
            throw new EPPAssemblerException("No Assembler registered withEPPDispatcher", EPPAssemblerException.FATAL);
        }
        EPPEvent event = this.assembler.toEvent(aInputStream, aData);
        EPPMessage message = event.getMessage();
        if (message instanceof EPPResponse) {
            cat.info("processMessage(): Invalid message type " + message.getClass().getName() + " for dispatching");
            throw new EPPEventException("Invalid request message type of response");
        }
        if (message instanceof EPPGreeting) {
            cat.info("processMessage(): Invalid message type " + message.getClass().getName() + " for dispatching");
            throw new EPPEventException("Invalid request message type of greeting");
        }
        String namespace = message.getNamespace();
        cat.debug("Sending event for Namespace " + namespace);
        EPPEventHandler handler = (EPPEventHandler)this.eventHandlers.get(namespace);
        if (handler == null) {
            cat.info("processMessage(): Handler not found for Namespace " + namespace);
            throw new EPPEventException("Handler not found for Namespace " + namespace);
        }
        EPPEventResponse eventResponse = handler.handleEvent(event, aData);
        if (eventResponse != null && eventResponse.getResponse() != null) {
            cat.debug("processMessage(InputStream, OutputStream, Object): Sending response to Assembler");
            this.assembler.toStream(eventResponse, aOutputStream, aData);
        } else {
            cat.debug("processMessage(InputStream, OutputStream, Object): No response to send to Assembler");
        }
        cat.debug("processMessage(InputStream, OutputStream, Object): Return");
    }

    public void registerHandler(EPPEventHandler aHandler) {
        this.eventHandlers.put(aHandler.getNamespace(), aHandler);
    }

    public void registerConnectionHandler(EPPConnectionHandler aConnectionHandler) {
        this.connectionHandler = aConnectionHandler;
    }

    public void send(EPPMessage aMessage, OutputStream aOutputStream) throws EPPAssemblerException {
        this.assembler.toStream(new EPPEventResponse(aMessage), aOutputStream, null);
    }

    public void send(EPPMessage aMessage, OutputStream aOutputStream, Object aData) throws EPPAssemblerException {
        this.assembler.toStream(new EPPEventResponse(aMessage), aOutputStream, aData);
    }
}

