/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCode;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfData;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfo;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeProfile;
import com.verisign.epp.codec.verificationcode.TrustAnchorVerificationCodeValidator;
import com.verisign.epp.codec.verificationcode.VerificationCodeRevocationList;
import com.verisign.epp.exception.EPPException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPVerificationCodeTst {
    private static long numIterations = 1L;
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static KeyStore trustStore;
    private static PKIXParameters pkixParameters;
    private static VerificationCodeRevocationList verificationCodeRevocationList;
    private static Certificate[] certChain;
    private static TrustAnchorVerificationCodeValidator verificationCodeValidator;
    private static final String KEYSTORE_FILENAME = "verificationCode.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String KEYSTORE_KEY_ALIAS = "verificationcode";
    private static final String KEYSTORE_CERT_ALIAS = "0:-1:china:domain~real-name:eppsdk:1";
    private static final String TRUSTSTORE_FILENAME = "verificationCode.jks";

    @Test
    public void testVerificationCode() {
        EPPCodecTst.printStart("testVerificationCode");
        EPPVerificationCode theCode = new EPPVerificationCode("abc-123", "domain");
        Assert.assertEquals((long)EPPVerificationCode.UNDEFINED, (long)theCode.getVspId());
        theCode = new EPPVerificationCode("1-abc123", "domain");
        Assert.assertEquals((long)1L, (long)theCode.getVspId());
        EPPCodecTst.printEnd("testVerificationCode");
    }

    @Test
    public void testDomainWithVerificationCode() {
        EPPCodecTst.printStart("testDomainWithVerificationCode");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "domain.example", new EPPAuthInfo("2fooBAR"));
        EPPSignedCode signedCode = null;
        EPPSignedCode encodedSignedCodeValue = null;
        try {
            signedCode = new EPPSignedCode("0-abc000", "domain");
            signedCode.sign(privateKey, certChain);
            System.out.println("Signed Code = " + signedCode);
            if (!signedCode.validate(publicKey)) {
                Assert.fail((String)"Signed code validation error using public key");
            }
            if (!signedCode.validate(pkixParameters)) {
                Assert.fail((String)"Signed code validation error using PKIX");
            }
            if (!verificationCodeValidator.validate(signedCode.getCode(), signedCode.getTrustAnchor())) {
                Assert.fail((String)"Verification code validation error");
            }
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            System.out.println("Encoded Signed Code = " + signedCode);
            if (verificationCodeRevocationList.isRevoked(encodedSignedCodeValue)) {
                Assert.fail((String)("testDomainWithVerificationCode(): Signed code with code = " + encodedSignedCodeValue.getCode() + " is unexpectedly revoked."));
            }
            theDomainCommand.addExtension(new EPPEncodedSignedCode((EPPEncodedSignedCodeValue)encodedSignedCodeValue));
        }
        catch (EPPEncodeException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPEncodeException: " + e));
        }
        catch (EPPException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPException: " + e));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Exception: " + e));
        }
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        if (!encodedSignedCodeValue.validate(pkixParameters)) {
            Assert.fail((String)"testDomainWithVerificationCode(): Signed code signature is NOT valid after command encode/decode");
        }
        try {
            if (!verificationCodeValidator.validate(encodedSignedCodeValue.getCode(), encodedSignedCodeValue.getTrustAnchor())) {
                Assert.fail((String)"testDomainWithVerificationCode(): Verification code validation error");
            }
        }
        catch (EPPException e) {
            e.printStackTrace();
            Assert.fail((String)("Exception: " + e));
        }
        EPPCodecTst.printEnd("testDomainWithVerificationCode");
    }

    @Test
    public void testInfo() {
        EPPCodecTst.printStart("testInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12345", "domain.example");
        theCommand.addExtension(new EPPVerificationCodeInfo());
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPDomainInfoCmd("ABC-12345", "domain.example");
        theCommand.addExtension(new EPPVerificationCodeInfo("sample"));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfo");
    }

    @Test
    public void testInfoResponse() {
        EPPCodecTst.printStart("testInfoResponse");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain1.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new Date());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.addExtension(new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.NOT_APPLICABLE));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain2.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new Date());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.addExtension(new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, new EPPVerificationCodeProfile("sample", EPPVerificationCodeProfile.Status.COMPLIANT)));
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain3.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3, 22, 0).getTime());
        theResponse.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile("sample", EPPVerificationCodeProfile.Status.COMPLIANT);
        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        EPPVerificationCodeInfData theExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
        theResponse.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain4.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3, 22, 0).getTime());
        theProfile = new EPPVerificationCodeProfile("sample", EPPVerificationCodeProfile.Status.COMPLIANT);
        theProfile.addSetCode(new EPPVerificationCode(null, "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theProfile.addSetCode(new EPPVerificationCode(null, "real-name", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
        theResponse.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain5.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("serverHold"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3, 22, 0).getTime());
        theProfile = new EPPVerificationCodeProfile("sample", EPPVerificationCodeProfile.Status.NON_COMPLIANT);
        theProfile.addMissingCode(new EPPVerificationCode("domain", new GregorianCalendar(1999, 4, 3, 22, 0).getTime()));
        theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(1999, 4, 3, 22, 0).getTime()));
        theExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.NON_COMPLIANT, theProfile);
        theResponse.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain6.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3, 22, 0).getTime());
        theProfile = new EPPVerificationCodeProfile("sample", EPPVerificationCodeProfile.Status.PENDING_COMPLIANCE);
        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE, theProfile);
        theResponse.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain7.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3, 22, 0).getTime());
        theExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE);
        theProfile = new EPPVerificationCodeProfile("sample1", EPPVerificationCodeProfile.Status.PENDING_COMPLIANCE);
        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theExt.addProfile(theProfile);
        theProfile = new EPPVerificationCodeProfile("sample2", EPPVerificationCodeProfile.Status.COMPLIANT);
        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theExt.addProfile(theProfile);
        theResponse.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        theResponse = new EPPDomainInfoResp();
        theResponse.setName("domain8.example");
        theResponse.setTransId(new EPPTransId("ABC-12345", "54322-XYZ"));
        theResponse.setRoid("EXAMPLE1-REP");
        statuses = new Vector();
        statuses.add(new EPPDomainStatus("ok"));
        theResponse.setStatuses(statuses);
        theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3, 22, 0).getTime());
        theResponse.setCreatedBy("ClientY");
        theResponse.setClientId("ClientX");
        theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3, 22, 0).getTime());
        theResponse.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        theProfile = new EPPVerificationCodeProfile("sample", EPPVerificationCodeProfile.Status.COMPLIANT);
        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
        theProfile = new EPPVerificationCodeProfile("sample2", EPPVerificationCodeProfile.Status.NOT_APPLICABLE);
        theProfile.addSetCode(new EPPVerificationCode("2-abc555", "domain", new GregorianCalendar(1999, 4, 3, 22, 0, 0).getTime()));
        theExt.addProfile(theProfile);
        theResponse.addExtension(theExt);
        theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponse");
    }

    @Test
    public void testDomainWithMultiVerificationCode() {
        EPPCodecTst.printStart("testDomainWithMultiVerificationCode");
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "domain.example", new EPPAuthInfo("2fooBAR"));
        EPPEncodedSignedCode encodedSignedCode = new EPPEncodedSignedCode();
        EPPSignedCode signedCode = null;
        EPPEncodedSignedCodeValue encodedSignedCodeValue = null;
        try {
            signedCode = new EPPSignedCode("0-abc111", "domain");
            signedCode.sign(privateKey, certChain);
            System.out.println("Signed Code = " + signedCode);
            if (!signedCode.validate(publicKey)) {
                Assert.fail((String)"Signed code validation error using public key");
            }
            if (!signedCode.validate(pkixParameters)) {
                Assert.fail((String)"Signed code validation error using PKIX");
            }
            if (!verificationCodeValidator.validate(signedCode.getCode(), signedCode.getTrustAnchor())) {
                Assert.fail((String)"Verification code validation error");
            }
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            System.out.println("Encoded Signed Code = " + signedCode);
            encodedSignedCode.addCode(encodedSignedCodeValue);
            signedCode = new EPPSignedCode("0-abc222", "real-name");
            signedCode.sign(privateKey, certChain);
            System.out.println("Signed Code = " + signedCode);
            if (!signedCode.validate(publicKey)) {
                Assert.fail((String)"Signed code validation error using public key");
            }
            if (!signedCode.validate(pkixParameters)) {
                Assert.fail((String)"Signed code validation error using PKIX");
            }
            if (!verificationCodeValidator.validate(signedCode.getCode(), signedCode.getTrustAnchor())) {
                Assert.fail((String)"Verification code validation error");
            }
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            System.out.println("Encoded Signed Code = " + signedCode);
            encodedSignedCode.addCode(encodedSignedCodeValue);
            theDomainCommand.addExtension(encodedSignedCode);
        }
        catch (EPPEncodeException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPEncodeException: " + e));
        }
        catch (EPPException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPException: " + e));
        }
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testDomainWithMultiVerificationCode");
    }

    @Test
    public void testEncodedSignedCode() {
        EPPCodecTst.printStart("testEncodedSignedCode");
        try {
            EPPEncodedSignedCodeValue encodedSignedCode = new EPPEncodedSignedCodeValue("0-abc000", "domain");
            encodedSignedCode.sign(privateKey, certChain);
            System.out.println("testEncodedSignedCode: Domain type '0-abc000' = " + encodedSignedCode);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            if (!verificationCodeValidator.validate(encodedSignedCode.getCode(), encodedSignedCode.getTrustAnchor())) {
                Assert.fail((String)"Verification code validation error");
            }
            String theEncodedValue = encodedSignedCode.encodeValue();
            System.out.println("testEncodedSignedCode: (old API) Base64 encoded signed code = " + theEncodedValue);
            encodedSignedCode = new EPPEncodedSignedCodeValue();
            encodedSignedCode.decode(Base64.decodeBase64((String)theEncodedValue));
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            theEncodedValue = encodedSignedCode.encodeValue();
            encodedSignedCode = new EPPEncodedSignedCodeValue();
            encodedSignedCode.decodeValue(theEncodedValue);
            System.out.println("testEncodedSignedCode: (new API) Base64 encoded signed code = " + theEncodedValue);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            theEncodedValue = encodedSignedCode.encodeValue(false);
            encodedSignedCode = new EPPEncodedSignedCodeValue();
            encodedSignedCode.decodeValue(theEncodedValue);
            System.out.println("testEncodedSignedCode: (new API) Base64 encoded signed code (no chunking) = " + theEncodedValue);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            encodedSignedCode = new EPPEncodedSignedCodeValue("0-rnvc111", "real-name");
            encodedSignedCode.sign(privateKey, certChain);
            System.out.println("testEncodedSignedCode: Real-name type '0-rnvc111' ) = " + encodedSignedCode);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            if (!verificationCodeValidator.validate(encodedSignedCode.getCode(), encodedSignedCode.getTrustAnchor())) {
                Assert.fail((String)"Verification code validation error");
            }
            encodedSignedCode = new EPPEncodedSignedCodeValue("0-dnvc222", "domain");
            encodedSignedCode.sign(privateKey, certChain);
            System.out.println("testEncodedSignedCode: Domain type '0-dnvc222' ) = " + encodedSignedCode);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            if (!verificationCodeValidator.validate(encodedSignedCode.getCode(), encodedSignedCode.getTrustAnchor())) {
                Assert.fail((String)"Verification code validation error");
            }
            encodedSignedCode = new EPPEncodedSignedCodeValue("99-abc333", "domain");
            encodedSignedCode.sign(privateKey, certChain);
            System.out.println("testEncodedSignedCode: Invalid vsp-id '99-abc333' ) = " + encodedSignedCode);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            if (verificationCodeValidator.validate(encodedSignedCode.getCode(), encodedSignedCode.getTrustAnchor())) {
                Assert.fail((String)"Incorrectly validated an invalid vsp-id in verification code");
            }
            encodedSignedCode = new EPPEncodedSignedCodeValue("0-abc444", "invalid");
            encodedSignedCode.sign(privateKey, certChain);
            System.out.println("testEncodedSignedCode: Invalid code type '0-abc444' ) = " + encodedSignedCode);
            if (!encodedSignedCode.validate(pkixParameters)) {
                Assert.fail((String)"Encoded signed code validation error using PKIX");
            }
            if (verificationCodeValidator.validate(encodedSignedCode.getCode(), encodedSignedCode.getTrustAnchor())) {
                Assert.fail((String)"Incorrectly validated an invalid code type in verification code");
            }
        }
        catch (EPPException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPException: " + e));
        }
        EPPCodecTst.printEnd("testEncodedSignedCode");
    }

    @BeforeClass
    public static void setup() {
        String numIterProp;
        EPPCodecTst.initEnvironment();
        try {
            KeyStore.PrivateKeyEntry keyEntry = EPPVerificationCodeTst.loadPrivateKeyEntry("verificationCode.jks", KEYSTORE_KEY_ALIAS, KEYSTORE_PASSWORD);
            privateKey = keyEntry.getPrivateKey();
            certChain = keyEntry.getCertificateChain();
            publicKey = EPPVerificationCodeTst.loadPublicKey("verificationCode.jks", KEYSTORE_CERT_ALIAS);
            pkixParameters = EPPVerificationCodeTst.loadPKIXParameters("verificationCode.jks");
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading keys for signing and validating: " + ex));
        }
        File verificationCodeRevocationListFile = new File("verification-code-test-revocation.csv");
        if (verificationCodeRevocationListFile.exists()) {
            try {
                FileInputStream smdRevocationListStream = new FileInputStream(verificationCodeRevocationListFile);
                verificationCodeRevocationList.decode(smdRevocationListStream);
                System.out.println("Verification Code Revocation List = [\n" + verificationCodeRevocationList + "]");
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)("Error opening Verification Code Revocation List File: " + e));
            }
            catch (EPPDecodeException e) {
                Assert.fail((String)("Error decoding Verification Code Revocation List File: " + e));
            }
        }
        if ((numIterProp = System.getProperty("iterations")) != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.verificationcode.EPPVerificationCodeExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static PKIXParameters loadPKIXParameters(String aTrustStoreName) throws Exception {
        trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        trustStore.load(trustStoreFile, null);
        PKIXParameters pkixParameters = new PKIXParameters(trustStore);
        pkixParameters.setRevocationEnabled(false);
        verificationCodeValidator = new TrustAnchorVerificationCodeValidator(trustStore);
        return pkixParameters;
    }

    private static KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String aKeyStoreName, String aKeyAliasName, String aPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, aPassword.toCharArray());
        assert (keyStore.isKeyEntry(aKeyAliasName));
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(aKeyAliasName, new KeyStore.PasswordProtection(aPassword.toCharArray()));
        return keyEntry;
    }

    public static PublicKey loadPublicKey(String aKeyStoreName, String aPublicKeyAlias) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, null);
        assert (keyStore.isCertificateEntry(aPublicKeyAlias));
        KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyStore.getEntry(aPublicKeyAlias, null);
        return certEntry.getTrustedCertificate().getPublicKey();
    }

    static {
        verificationCodeRevocationList = new VerificationCodeRevocationList();
    }
}

