/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPEncodedSignedCode
implements EPPCodecComponent {
    private static final long serialVersionUID = -2581814950269930902L;
    private static Logger cat = LoggerFactory.getLogger(EPPEncodedSignedCode.class);
    public static final String ELM_LOCALNAME = "encodedSignedCode";
    public static final String ELM_NAME = "verificationCode:encodedSignedCode";
    List<EPPEncodedSignedCodeValue> codes = new ArrayList<EPPEncodedSignedCodeValue>();

    public EPPEncodedSignedCode() {
    }

    public EPPEncodedSignedCode(EPPSignedCode aSignedCode) throws EPPEncodeException, EPPDecodeException {
        this.codes.add(new EPPEncodedSignedCodeValue(aSignedCode));
    }

    public EPPEncodedSignedCode(EPPEncodedSignedCodeValue aEncodedSignedCodeValue) {
        this.codes.add(aEncodedSignedCodeValue);
    }

    public EPPEncodedSignedCode(EPPVerificationCode aCode) throws EPPEncodeException {
        this.codes.add(new EPPEncodedSignedCodeValue(aCode));
    }

    public EPPEncodedSignedCode(String aCode, String aType) throws EPPEncodeException {
        this.codes.add(new EPPEncodedSignedCodeValue(aCode, aType));
    }

    public EPPEncodedSignedCode(List<EPPEncodedSignedCodeValue> aCodes) {
        this.codes = aCodes != null ? aCodes : new ArrayList<EPPEncodedSignedCodeValue>();
    }

    public boolean hasCodes() {
        return this.codes != null && !this.codes.isEmpty();
    }

    public List<EPPEncodedSignedCodeValue> getSignedCodes() {
        return this.codes;
    }

    public void setSignedCodes(List<EPPEncodedSignedCodeValue> aCodes) {
        this.codes = aCodes;
    }

    public void setCode(EPPEncodedSignedCodeValue aCode) {
        this.codes = new ArrayList<EPPEncodedSignedCodeValue>();
        this.codes.add(aCode);
    }

    public void addCode(EPPEncodedSignedCodeValue aCode) {
        if (this.codes == null) {
            this.codes = new ArrayList<EPPEncodedSignedCodeValue>();
        }
        this.codes.add(aCode);
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug("EPPEncodedSignedCode.decode(Element): enter");
        this.codes = new ArrayList<EPPEncodedSignedCodeValue>();
        Vector theChildren = EPPUtil.getElementsByTagNameNS(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", "code");
        if (theChildren.size() != 0) {
            for (int i = 0; i < theChildren.size(); ++i) {
                EPPEncodedSignedCodeValue signedCode = new EPPEncodedSignedCodeValue();
                signedCode.decode((Element)theChildren.elementAt(i));
                this.codes.add(signedCode);
            }
        }
        cat.debug("EPPEncodedSignedCode.decode(Element): exit - normal");
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug("EPPEncodedSignedCode.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSignedCode.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.codes);
        cat.debug("EPPEncodedSignedCode.encode(Document): exit");
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEncodedSignedCode)) {
            cat.error("EPPEncodedSignedCode.equals(): " + aObject.getClass().getName() + " not EPPEncodedSignedCode instance");
            return false;
        }
        EPPEncodedSignedCode other = (EPPEncodedSignedCode)aObject;
        if (!EqualityUtil.equals(this.codes, other.codes)) {
            cat.error("EPPEncodedSignedCode.equals(): codes not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPEncodedSignedCode clone = (EPPEncodedSignedCode)super.clone();
        clone.codes = new ArrayList<EPPEncodedSignedCodeValue>(this.codes.size());
        for (EPPEncodedSignedCodeValue item : this.codes) {
            clone.codes.add((EPPEncodedSignedCodeValue)item.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:verificationCode-1.0";
    }
}

