/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.validate.v02.EPPValidateAddress;
import com.verisign.epp.codec.validate.v02.EPPValidateAuthInfo;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckCmd;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResp;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResult;
import com.verisign.epp.codec.validate.v02.EPPValidateContact;
import com.verisign.epp.codec.validate.v02.EPPValidateKeyValue;
import com.verisign.epp.codec.validate.v02.EPPValidatePostalDefinition;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPValidateTst {
    private static long numIterations = 1L;

    @Test
    public void testCheckCommand() {
        EPPCodecTst.printStart("testCheckCommand");
        EPPValidateCheckCmd theCommand = new EPPValidateCheckCmd("ABC-12345");
        EPPValidateContact theContact = new EPPValidateContact("sh8013", "registrant", "COM");
        EPPValidateAddress theAddress = new EPPValidateAddress();
        theAddress.setStreets("123 Example Dr.", "Suite 100");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        EPPValidatePostalDefinition thePostalDef = new EPPValidatePostalDefinition(EPPValidatePostalDefinition.Type.INT, "John Doe", theAddress);
        thePostalDef.setOrg("Example Inc.");
        theContact.addPostalInfo(thePostalDef);
        theContact.setVoice("+1.7035555555");
        theContact.setFax("+1.7035555556");
        theContact.setEmail("jdoe@example.com");
        theContact.setAuthInfo(new EPPValidateAuthInfo("2fooBAR"));
        theContact.addKeyValue(new EPPValidateKeyValue("VAT", "1234567890"));
        theCommand.addContact(theContact);
        theCommand.addContact(new EPPValidateContact("sh8012", "tech", "COM"));
        theContact = new EPPValidateContact("sh8014", "admin", "COM");
        theAddress = new EPPValidateAddress();
        theAddress.setStreets("123 Example Dr.", "Suite 100");
        theAddress.setCity("Dulles");
        theAddress.setStateProvince("VA");
        theAddress.setPostalCode("20166-6503");
        theAddress.setCountry("US");
        thePostalDef = new EPPValidatePostalDefinition(EPPValidatePostalDefinition.Type.INT, "John Doe", theAddress);
        thePostalDef.setOrg("Example Inc.");
        theContact.addPostalInfo(thePostalDef);
        theContact.setVoice("+1.7035555555");
        theContact.setFax("+1.7035555556");
        theContact.setEmail("jdoe@example.com");
        theContact.setAuthInfo(new EPPValidateAuthInfo("2fooBAR"));
        theCommand.addContact(theContact);
        try {
            theContact = (EPPValidateContact)theContact.clone();
            theContact.setContactType("billing");
            theCommand.addContact(theContact);
        }
        catch (CloneNotSupportedException e) {
            Assert.fail((String)("CloneNotSupportedException cloning sh8014 for billing contact: " + e));
        }
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckCommand");
    }

    @Test
    public void testCheckResponse() {
        EPPCodecTst.printStart("testCheckResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPValidateCheckResp theResponse = new EPPValidateCheckResp(theTransId);
        theResponse.addResult(new EPPValidateCheckResult("sh8013", 1000));
        EPPValidateCheckResult theResult = new EPPValidateCheckResult("sh8014", 2306);
        theResult.addKeyValue(new EPPValidateKeyValue("contact:city", "City not valid for state."));
        theResult.addKeyValue(new EPPValidateKeyValue("contact:cc", "Invalid country code for admin, must be mx.", "Admin"));
        theResult.addKeyValue(new EPPValidateKeyValue("VAT", "VAT required for Billing contact.", "Billing"));
        theResponse.addResult(theResult);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckResponse");
    }

    @BeforeClass
    public static void setup() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.validate.v02.EPPValidateMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

