/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.validate.v02.EPPValidateKeyValue;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPValidateCheckResult
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPValidateCheckResult.class);
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "validate:cd";
    private static final String ELM_ID = "id";
    private static final String ELM_CODE = "response";
    private String id;
    private int code = -1;
    private List<EPPValidateKeyValue> keyValues = new ArrayList<EPPValidateKeyValue>();

    public EPPValidateCheckResult() {
    }

    public EPPValidateCheckResult(String aId, int aCode) {
        this.id = aId;
        this.code = aCode;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int aCode) {
        this.code = aCode;
    }

    public void addKeyValue(EPPValidateKeyValue aKeyValue) {
        this.keyValues.add(aKeyValue);
    }

    public void setKeyValues(List<EPPValidateKeyValue> aKeyValues) {
        this.keyValues = aKeyValues == null ? new ArrayList<EPPValidateKeyValue>() : aKeyValues;
    }

    public List<EPPValidateKeyValue> getKeyValues() {
        return this.keyValues;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.id == null) {
            throw new EPPEncodeException("Undefined id in EPPValidateCheckResult");
        }
        if (this.code == -1) {
            throw new EPPEncodeException("Undefined code in EPPValidateCheckResult");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:validate-0.2", "validate:id");
        EPPUtil.encodeInteger(aDocument, root, this.code, "urn:ietf:params:xml:ns:validate-0.2", "validate:response");
        EPPUtil.encodeCompList(aDocument, root, this.keyValues);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:validate-0.2", ELM_ID);
        this.code = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:validate-0.2", ELM_CODE);
        this.keyValues = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:validate-0.2", "validate:kv", EPPValidateKeyValue.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateCheckResult)) {
            return false;
        }
        EPPValidateCheckResult other = (EPPValidateCheckResult)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error("EPPValidateCheckResult.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error("EPPValidateCheckResult.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.keyValues, other.keyValues)) {
            cat.error("EPPValidateCheckResult.equals(): keyValues not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateCheckResult clone = null;
        clone = (EPPValidateCheckResult)super.clone();
        clone.keyValues = new ArrayList<EPPValidateKeyValue>(this.keyValues.size());
        for (EPPValidateKeyValue item : this.keyValues) {
            clone.keyValues.add((EPPValidateKeyValue)item.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }
}

