/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.validate.v02.EPPValidateContact;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPValidateCheckCmd
extends EPPCheckCmd {
    public static final String ELM_LOCALNAME = "check";
    static final String ELM_NAME = "validate:check";
    private static Logger cat = LoggerFactory.getLogger(EPPValidateCheckCmd.class);
    private List<EPPValidateContact> contacts = new ArrayList<EPPValidateContact>();

    public EPPValidateCheckCmd() {
    }

    public EPPValidateCheckCmd(String aTransId) {
        super(aTransId);
    }

    public EPPValidateCheckCmd(String aTransId, EPPValidateContact aContact) {
        super(aTransId);
        this.contacts.add(aContact);
    }

    public EPPValidateCheckCmd(String aTransId, List<EPPValidateContact> aContacts) {
        super(aTransId);
        this.contacts = aContacts;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }

    @Override
    public String getKey() {
        if (this.contacts != null && this.contacts.size() == 1) {
            return this.contacts.get(0).getId();
        }
        return null;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPValidateCheckCmd other = (EPPValidateCheckCmd)aObject;
        if (!EqualityUtil.equals(this.contacts, other.contacts)) {
            cat.error("EPPValidateCheckCmd.equals(): contacts not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateCheckCmd clone = (EPPValidateCheckCmd)super.clone();
        if (this.hasContacts()) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void setContact(EPPValidateContact aContact) {
        this.contacts = new ArrayList<EPPValidateContact>();
        this.contacts.add(aContact);
    }

    public List<EPPValidateContact> getContacts() {
        return this.contacts;
    }

    public void setLabels(List<EPPValidateContact> aContacts) {
        this.contacts = aContacts == null ? new ArrayList<EPPValidateContact>() : aContacts;
    }

    public void addContact(EPPValidateContact aContact) {
        this.contacts.add(aContact);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.contacts.size() == 0) {
            throw new EPPEncodeException("No labels specified in EPPValidateCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:validate-0.2", "validate:contact", EPPValidateContact.class);
    }
}

