/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.ttl.v1_0;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.host.EPPHostStatus;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.ttl.v1_0.EPPTtl;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlCreate;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfData;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlInfo;
import com.verisign.epp.codec.ttl.v1_0.EPPTtlUpdate;
import com.verisign.epp.codec.ttl.v1_0.RRecType;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPTtlTst {
    @Test
    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo(""));
        theCommand.setPeriod(new EPPDomainPeriod(1));
        Vector<String> servers = new Vector<String>();
        servers.add("ns1.example.com");
        servers.add("ns1.example.net");
        theCommand.setServers(servers);
        EPPTtlCreate theTtlExt = new EPPTtlCreate();
        theTtlExt.addTtl(new EPPTtl(RRecType.NS, 172800));
        theTtlExt.addTtl(new EPPTtl(RRecType.DS, 300));
        theTtlExt.addTtl(new EPPTtl(RRecType.CUSTOM, "DELEG", 3600));
        theCommand.addExtension(theTtlExt);
        EPPSecDNSExtCreate theDnssecExt = new EPPSecDNSExtCreate();
        theDnssecExt.appendDsData(new EPPSecDNSExtDsData(12345, 13, 2, "49FD46E6C4B45C55D4AC"));
        theCommand.addExtension(theDnssecExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    @Test
    public void testHostCreate() {
        EPPCodecTst.printStart("testHostCreate");
        EPPHostCreateCmd theCommand = new EPPHostCreateCmd("ABC-12345", "ns1.example.com");
        Vector<EPPHostAddress> addresses = new Vector<EPPHostAddress>();
        addresses.addElement(new EPPHostAddress("192.0.2.2", 0));
        addresses.addElement(new EPPHostAddress("1080::8:800:200C:417A", 1));
        theCommand.setAddresses(addresses);
        EPPTtlCreate theCreateExt = new EPPTtlCreate();
        theCreateExt.addTtl(new EPPTtl(RRecType.A));
        theCreateExt.addTtl(new EPPTtl(RRecType.AAAA, 86400));
        theCommand.addExtension(theCreateExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testHostCreate");
    }

    @Test
    public void testDomainUpdate() {
        EPPCodecTst.printStart("testDomainUpdate");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345", "example.com", null, null, null);
        EPPTtlUpdate theUpdateExt = new EPPTtlUpdate();
        theUpdateExt.addTtl(new EPPTtl(RRecType.NS));
        theCommand.addExtension(theUpdateExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    @Test
    public void testHostUpdate() {
        EPPCodecTst.printStart("testHostUpdate");
        EPPHostUpdateCmd theCommand = new EPPHostUpdateCmd("ABC-12345", "ns1.example.com", null, null, null);
        EPPTtlUpdate theUpdateExt = new EPPTtlUpdate();
        theUpdateExt.addTtl(new EPPTtl(RRecType.A, 86400));
        theUpdateExt.addTtl(new EPPTtl(RRecType.AAAA, 3600));
        theCommand.addExtension(theUpdateExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testHostUpdate");
    }

    @Test
    public void testDomainInfo() {
        EPPCodecTst.printStart("testDomainInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd(null, "example.com");
        theCommand.addExtension(new EPPTtlInfo());
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainInfoCmd(null, "example.com");
        theCommand.addExtension(new EPPTtlInfo());
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainInfoCmd(null, "example.com");
        theCommand.addExtension(new EPPTtlInfo(true));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
    }

    @Test
    public void testDomainInfoResponse() {
        EPPCodecTst.printStart("testDomainInfoResponse");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-REP", "example.com", "ClientX", statuses, "ClientX", new GregorianCalendar(2023, 11, 8, 10, 14, 55).getTime(), null);
        Vector<String> servers = new Vector<String>();
        servers.add("ns1.example.com");
        servers.add("ns1.example.net");
        theResponse.setNses(servers);
        theResponse.setExpirationDate(new GregorianCalendar(2024, 11, 8, 10, 14, 55).getTime());
        theResponse.setResult(1000);
        EPPTtlInfData theInfExt = new EPPTtlInfData();
        theInfExt.addTtl(new EPPTtl(RRecType.NS, 172800));
        theInfExt.addTtl(new EPPTtl(RRecType.DS, 300));
        theResponse.addExtension(theInfExt);
        EPPSecDNSExtCreate theDnssecExt = new EPPSecDNSExtCreate();
        theDnssecExt.appendDsData(new EPPSecDNSExtDsData(12345, 13, 2, "49FD46E6C4B45C55D4AC"));
        theResponse.addExtension(theDnssecExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        statuses = new Vector();
        statuses.addElement(new EPPDomainStatus("ok"));
        respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-REP", "example.com", "ClientX", statuses, "ClientX", new GregorianCalendar(2023, 11, 8, 10, 14, 55).getTime(), null);
        servers = new Vector();
        servers.add("ns1.example.com");
        servers.add("ns1.example.net");
        theResponse.setNses(servers);
        theResponse.setExpirationDate(new GregorianCalendar(2024, 11, 8, 10, 14, 55).getTime());
        theResponse.setResult(1000);
        theInfExt = new EPPTtlInfData();
        theInfExt.addTtl(new EPPTtl(RRecType.NS, null, 3600, 172800, 86400, 172800));
        theInfExt.addTtl(new EPPTtl(RRecType.DS, null, 60, 172800, 86400, 300));
        theResponse.addExtension(theInfExt);
        theDnssecExt = new EPPSecDNSExtCreate();
        theDnssecExt.appendDsData(new EPPSecDNSExtDsData(12345, 13, 2, "49FD46E6C4B45C55D4AC"));
        theResponse.addExtension(theDnssecExt);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainInfoResponse");
    }

    @Test
    public void testHostInfo() {
        EPPCodecTst.printStart("testHostInfo");
        EPPHostInfoCmd theCommand = new EPPHostInfoCmd(null, "ns1.example.com");
        theCommand.addExtension(new EPPTtlInfo());
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPHostInfoCmd(null, "ns1.example.com");
        theCommand.addExtension(new EPPTtlInfo());
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPHostInfoCmd(null, "ns1.example.com");
        theCommand.addExtension(new EPPTtlInfo(true));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
    }

    @Test
    public void testHostInfoResponse() {
        EPPCodecTst.printStart("testHostInfoResponse");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPHostInfoResp theResponse = new EPPHostInfoResp(respTransId, "n1.example.com", "NS1_EXAMPLE1-REP", new EPPHostStatus("ok"), "ClientX", "ClientX", new GregorianCalendar(2023, 11, 8, 10, 14, 55).getTime());
        Vector<EPPHostAddress> addresses = new Vector<EPPHostAddress>();
        addresses.addElement(new EPPHostAddress("192.0.2.2", 0));
        addresses.addElement(new EPPHostAddress("1080::8:800:200C:417A", 1));
        theResponse.setAddresses(addresses);
        theResponse.setResult(1000);
        EPPTtlInfData theInfExt = new EPPTtlInfData();
        theInfExt.addTtl(new EPPTtl(RRecType.A, 172800));
        theInfExt.addTtl(new EPPTtl(RRecType.AAAA, 86400));
        theResponse.addExtension(theInfExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        theResponse = new EPPHostInfoResp(respTransId, "n1.example.com", "NS1_EXAMPLE1-REP", new EPPHostStatus("ok"), "ClientX", "ClientX", new GregorianCalendar(2023, 11, 8, 10, 14, 55).getTime());
        addresses = new Vector();
        addresses.addElement(new EPPHostAddress("192.0.2.2", 0));
        addresses.addElement(new EPPHostAddress("1080::8:800:200C:417A", 1));
        theResponse.setAddresses(addresses);
        theResponse.setResult(1000);
        theInfExt = new EPPTtlInfData();
        theInfExt.addTtl(new EPPTtl(RRecType.A, null, 3600, 172800, 86400, 172800));
        theInfExt.addTtl(new EPPTtl(RRecType.AAAA, null, 3600, 172800, 86400, 86400));
        theResponse.addExtension(theInfExt);
        commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testHostInfoResponse");
    }

    @BeforeClass
    public static void setup() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.ttl.v1_0.EPPTtlExtFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }
}

