/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.ttl.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPTtlInfo
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "ttl:info";
    private static final String ATTR_POLICY = "policy";
    private static Logger cat = LoggerFactory.getLogger(EPPTtlInfo.class);
    private boolean policy = false;

    protected String getLocalName() {
        return ELM_LOCALNAME;
    }

    public EPPTtlInfo() {
    }

    public EPPTtlInfo(boolean aPolicy) {
        this.policy = aPolicy;
    }

    public boolean isPolicy() {
        return this.policy;
    }

    public void setPolicy(boolean aPolicy) {
        this.policy = aPolicy;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:ttl-1.0", ELM_NAME);
        EPPUtil.encodeBooleanAttr(root, ATTR_POLICY, this.policy);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.policy = aElement.getAttribute(ATTR_POLICY) == null ? false : EPPUtil.decodeBooleanAttr(aElement, ATTR_POLICY);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPTtlInfo clone = (EPPTtlInfo)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPTtlInfo)) {
            cat.error("EPPTtlInfo.equals(): " + aObject.getClass().getName() + " not EPPTtlInfo instance");
            return false;
        }
        EPPTtlInfo other = (EPPTtlInfo)aObject;
        if (!EqualityUtil.equals(this.policy, other.policy)) {
            cat.error("EPPTtlInfo.equals(): policy not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:ttl-1.0";
    }
}

