/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.ttl.v1_0;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.ttl.v1_0.RRecType;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPTtl
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPTtl.class);
    public static final String ELM_LOCALNAME = "ttl";
    public static final String ELM_NAME = "ttl:ttl";
    private static final String ATTR_FOR = "for";
    private static final String ATTR_CUSTOM = "custom";
    private static final String ATTR_MIN = "min";
    private static final String ATTR_MAX = "max";
    private static final String ATTR_DEFAULT = "default";
    private RRecType rrecType;
    private String custom;
    private Integer minValue;
    private Integer maxValue;
    private Integer defaultValue;
    private Integer value;

    public EPPTtl() {
    }

    public EPPTtl(RRecType aRRecType) {
        this.setRRecType(aRRecType);
    }

    public EPPTtl(RRecType aRRecType, String aCustom) {
        this.setRRecType(aRRecType);
        this.setCustom(aCustom);
    }

    public EPPTtl(RRecType aRRecType, Integer aValue) {
        this.setRRecType(aRRecType);
        this.setValue(aValue);
    }

    public EPPTtl(RRecType aRRecType, String aCustom, Integer aValue) {
        this.setRRecType(aRRecType);
        this.setCustom(aCustom);
        this.setValue(aValue);
    }

    public EPPTtl(RRecType aRRecType, String aCustom, Integer aMinValue, Integer aMaxValue, Integer aDefaultValue, Integer aValue) {
        this.setRRecType(aRRecType);
        this.setCustom(aCustom);
        this.setMinValue(aMinValue);
        this.setMaxValue(aMaxValue);
        this.setDefaultValue(aDefaultValue);
        this.setValue(aValue);
    }

    public RRecType getRRecType() {
        return this.rrecType;
    }

    public void setRRecType(RRecType aRRecType) {
        this.rrecType = aRRecType;
        cat.debug("setRRecType: rrecType = " + this.rrecType);
    }

    public boolean hasCustom() {
        return this.custom != null;
    }

    public String getCustom() {
        return this.custom;
    }

    public void setCustom(String aCustom) {
        this.custom = aCustom;
        cat.debug("setCustom: custom = " + this.custom);
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer aMinValue) {
        this.minValue = aMinValue;
        cat.debug("setMinValue: minValue = " + this.minValue);
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer aMaxValue) {
        this.maxValue = aMaxValue;
        cat.debug("setMaxValue: maxValue = " + this.maxValue);
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Integer aDefaultValue) {
        this.defaultValue = aDefaultValue;
        cat.debug("setDefaultValue: defaultValue = " + this.defaultValue);
    }

    public boolean hasPolicyValues() {
        return this.hasMinValue() && this.hasMaxValue() && this.hasDefaultValue();
    }

    public void setPolicyValues(Integer aMinValue, Integer aMaxValue, Integer aDefaultValue) {
        this.setMinValue(aMinValue);
        this.setMaxValue(aMaxValue);
        this.setDefaultValue(aDefaultValue);
    }

    public void unsetPolicyValues() {
        this.setMinValue(null);
        this.setMaxValue(null);
        this.setDefaultValue(null);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer aValue) {
        this.value = aValue;
        cat.debug("setValue: value = " + this.value);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPTtl clone = null;
        clone = (EPPTtl)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theRRecType = EPPUtil.decodeStringAttr(aElement, ATTR_FOR);
        if (theRRecType != null) {
            this.rrecType = RRecType.getRRecType(theRRecType);
            this.setRRecType(this.rrecType);
        } else {
            this.setRRecType(null);
        }
        this.setCustom(EPPUtil.decodeStringAttr(aElement, ATTR_CUSTOM));
        String theStrAttr = EPPUtil.decodeStringAttr(aElement, ATTR_MIN);
        if (theStrAttr != null) {
            this.setMinValue(Integer.decode(theStrAttr));
        } else {
            this.setMinValue(null);
        }
        theStrAttr = EPPUtil.decodeStringAttr(aElement, ATTR_MAX);
        if (theStrAttr != null) {
            this.setMaxValue(Integer.decode(theStrAttr));
        } else {
            this.setMaxValue(null);
        }
        theStrAttr = EPPUtil.decodeStringAttr(aElement, ATTR_DEFAULT);
        if (theStrAttr != null) {
            this.setDefaultValue(Integer.decode(theStrAttr));
        } else {
            this.setDefaultValue(null);
        }
        String theValueStr = EPPUtil.getTextContent(aElement, true);
        if (!theValueStr.isEmpty()) {
            this.setValue(Integer.decode(theValueStr));
        } else {
            this.setValue(null);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPTtl.encode(Document)");
        }
        if (this.rrecType == null) {
            throw new EPPEncodeException("rrecType is null in EPPTtl.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:ttl-1.0", ELM_NAME);
        root.setAttribute(ATTR_FOR, this.rrecType.toString());
        if (this.hasCustom()) {
            root.setAttribute(ATTR_CUSTOM, this.custom);
        }
        if (this.hasMinValue()) {
            root.setAttribute(ATTR_MIN, this.minValue.toString());
        }
        if (this.hasMaxValue()) {
            root.setAttribute(ATTR_MAX, this.maxValue.toString());
        }
        if (this.hasDefaultValue()) {
            root.setAttribute(ATTR_DEFAULT, this.defaultValue.toString());
        }
        if (this.hasValue()) {
            Text theValue = aDocument.createTextNode(this.value.toString());
            root.appendChild(theValue);
        }
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPTtl)) {
            return false;
        }
        EPPTtl other = (EPPTtl)aObject;
        if (!EqualityUtil.equals((Object)this.rrecType, (Object)other.rrecType)) {
            cat.error("EPPTtl.equals(): rrecType not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.custom, other.custom)) {
            cat.error("EPPTtl.equals(): custom not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.minValue, other.minValue)) {
            cat.error("EPPTtl.equals(): minValue not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxValue, other.maxValue)) {
            cat.error("EPPTtl.equals(): maxValue not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.defaultValue, other.defaultValue)) {
            cat.error("EPPTtl.equals(): defaultValue not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.value, other.value)) {
            cat.error("EPPTtl.equals(): value not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:ttl-1.0";
    }
}

