/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.syncext;

import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.syncext.EPPSyncExtUpdate;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPSyncExtTst {
    private static long numIterations = 1L;

    @Test
    public void testDomainUpdateCommandWithSyncExt() {
        EPPCodecTst.printStart("testDomainUpdateCommandWithSyncExt");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("example.com");
        theCommand.setTransId("ABC-12345-XYZ");
        EPPSyncExtUpdate syncUpdate = new EPPSyncExtUpdate();
        syncUpdate.setMonth(11);
        syncUpdate.setDay(30);
        theCommand.addExtension(syncUpdate);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example2.com");
        theCommand.setTransId("ABC-12345-XYZ");
        syncUpdate = new EPPSyncExtUpdate();
        syncUpdate.setMonth(0);
        syncUpdate.setDay(1);
        theCommand.addExtension(syncUpdate);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainUpdateCmd("example3.com");
        theCommand.setTransId("ABC-12345-XYZ");
        syncUpdate = new EPPSyncExtUpdate();
        syncUpdate.setMonth(1);
        syncUpdate.setDay(29);
        theCommand.addExtension(syncUpdate);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateCommandWithSyncExt");
    }

    @BeforeClass
    public static void setup() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.syncext.EPPSyncExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPSyncExtFactory to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

