/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.signedMark;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedSMD
implements Serializable,
Cloneable {
    private static Logger cat = LoggerFactory.getLogger(RevokedSMD.class);
    private String id;
    private Date revokedDate;

    public RevokedSMD() {
    }

    public RevokedSMD(String aId, Date aRevokedDate) {
        this.id = aId;
        this.revokedDate = aRevokedDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public Date getRevokedDate() {
        return this.revokedDate;
    }

    public void setRevokedDate(Date aRevokedDate) {
        this.revokedDate = aRevokedDate;
    }

    public String encode() throws EPPEncodeException {
        cat.debug("encode(): enter");
        if (this.id == null) {
            throw new EPPEncodeException("encode(): id required attribute is null.");
        }
        if (this.revokedDate == null) {
            throw new EPPEncodeException("encode(): revokedDate required attribute is null.");
        }
        String ret = this.id + "," + EPPUtil.encodeTimeInstant(this.revokedDate);
        cat.debug("encode(): Encoded value = \"" + ret + "\"");
        cat.debug("encode(): exit");
        return ret;
    }

    public void decode(String aLine) throws EPPDecodeException {
        cat.debug("decode(String): enter");
        int sepIndex = aLine.indexOf(44);
        if (sepIndex == -1) {
            throw new EPPDecodeException("decode(): , seperator not found in revoked SMD line");
        }
        this.id = aLine.substring(0, sepIndex);
        String revokedDateStr = aLine.substring(sepIndex + 1);
        this.revokedDate = EPPUtil.decodeTimeInstant(revokedDateStr);
        if (this.revokedDate == null) {
            throw new EPPDecodeException("decode(): Error decoding the revoked date");
        }
        cat.debug("decode(String): exit");
    }

    public Object clone() throws CloneNotSupportedException {
        RevokedSMD clone = (RevokedSMD)super.clone();
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof RevokedSMD)) {
            cat.error("RevokedSMD.equals(): aObject is not an RevokedSMD");
            return false;
        }
        RevokedSMD other = (RevokedSMD)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error("RevokedSMD.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.revokedDate, other.revokedDate)) {
            cat.error("RevokedSMD.equals(): revokedDate not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            return this.encode();
        }
        catch (EPPEncodeException e) {
            throw new RuntimeException(e);
        }
    }
}

