/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.signedMark;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.signedMark.EPPIssuer;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.util.EPPSchemaCachingParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPEncodedSignedMark
extends EPPSignedMark {
    private static final long serialVersionUID = -2581814950269930902L;
    private static Logger cat = LoggerFactory.getLogger(EPPEncodedSignedMark.class);
    public static final String ELM_ENCODED_SIGNED_MARK_LOCALNAME = "encodedSignedMark";
    public static final String ELM_ENCODED_SIGNED_MARK_NAME = "signedMark:encodedSignedMark";

    public EPPEncodedSignedMark() {
    }

    public EPPEncodedSignedMark(EPPSignedMark aSignedMark) throws EPPEncodeException, EPPDecodeException {
        super(aSignedMark.encode());
    }

    public EPPEncodedSignedMark(String aId, EPPIssuer aIssuer, Date aNotBefore, Date aNotAfter, EPPMark aMark) throws EPPEncodeException, EPPDecodeException {
        super(aId, aIssuer, aNotBefore, aNotAfter, aMark);
    }

    public EPPEncodedSignedMark(byte[] aEncodedSignedMarkArray) throws EPPDecodeException {
        cat.debug("EPPSignedMark(byte[]): enter");
        byte[] signedMarkXML = null;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(aEncodedSignedMarkArray);
            EPPSchemaCachingParser parser = new EPPSchemaCachingParser();
            Document doc = ((DocumentBuilder)parser).parse(is);
            Element elm = doc.getDocumentElement();
            String base64SignedMark = EPPUtil.getTextContent(elm);
            signedMarkXML = Base64.decodeBase64((String)base64SignedMark);
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding signed mark array: " + ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                    is = null;
                }
                catch (IOException iOException) {}
            }
        }
        super.decode(signedMarkXML);
        cat.debug("EPPSignedMark.decode(byte[]): exit");
    }

    public EPPEncodedSignedMark(InputStream aSMD) throws EPPDecodeException {
        cat.debug("EPPEncodedSignedMark.EPPEncodedSignedMark(InputStream): enter");
        StringBuffer smdBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(aSMD));
        boolean addToSMD = false;
        try {
            String currLine;
            while ((currLine = bufferedReader.readLine()) != null) {
                if (currLine.equals("-----BEGIN ENCODED SMD-----")) {
                    addToSMD = true;
                    continue;
                }
                if (currLine.equals("-----END ENCODED SMD-----")) {
                    addToSMD = false;
                    continue;
                }
                if (!addToSMD) continue;
                smdBuffer.append(currLine);
            }
        }
        catch (IOException e) {
            throw new EPPDecodeException("Error reading SMD: " + e);
        }
        byte[] signedMarkXML = Base64.decodeBase64((String)smdBuffer.toString());
        super.decode(signedMarkXML);
        cat.debug("EPPEncodedSignedMark.EPPEncodedSignedMark(InputStream): exit");
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug("EPPEncodedSignedMark.decode(Element): enter");
        String base64SignedMark = EPPUtil.getTextContent(aElement);
        byte[] signedMarkXML = Base64.decodeBase64((String)base64SignedMark);
        super.decode(signedMarkXML);
        cat.debug("EPPEncodedSignedMark.decode(Element): exit - normal");
    }

    @Override
    public byte[] encode() throws EPPEncodeException {
        cat.debug("EPPEncodedSignedMark.encode(): enter");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error("Error encoding trademark to byte[]: " + ex);
            throw new EPPEncodeException("Error encoding trademark to byte[]");
        }
        cat.debug("EPPEncodedSignedMark.encode(): exit");
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug("EPPEncodedSignedMark.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSignedMark.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:signedMark-1.0", ELM_ENCODED_SIGNED_MARK_NAME);
        byte[] signedMarkXml = super.encode();
        String base64EncodedText = new String(Base64.encodeBase64((byte[])signedMarkXml, (boolean)true));
        Text currVal = aDocument.createTextNode(base64EncodedText);
        root.appendChild(currVal);
        cat.debug("EPPEncodedSignedMark.encode(Document): exit - encoded");
        return root;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPEncodedSignedMark)super.clone();
    }
}

