/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPExtFactory;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpData;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpdate;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPRgpExtFactory
extends EPPExtFactory {
    public static final String NS = "urn:ietf:params:xml:ns:rgp-1.0";
    public static final String NS_PREFIX = "rgp";
    private EPPService service = new EPPService("rgp", "urn:ietf:params:xml:ns:rgp-1.0");

    public EPPRgpExtFactory() {
        this.service.setServiceType(1);
    }

    @Override
    public EPPProtocolExtension createProtocolExtension(Element aExtensionElm) throws EPPCodecException {
        throw new EPPCodecException("EPPRgpExtFactory.createProtocolExtension: Protocol extensions not supported");
    }

    @Override
    public EPPCodecComponent createExtension(Element aExtensionElm) throws EPPCodecException {
        String name = aExtensionElm.getLocalName();
        if (!aExtensionElm.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid extension type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("rgp:infData"))) {
            return new EPPRgpExtInfData();
        }
        if (name.equals(EPPUtil.getLocalName("rgp:update"))) {
            return new EPPRgpExtUpdate();
        }
        if (name.equals(EPPUtil.getLocalName("rgp:upData"))) {
            return new EPPRgpExtUpData();
        }
        throw new EPPCodecException("Invalid extension element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    public Set getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        theSchemas.add("rgp-1.0.xsd");
        return theSchemas;
    }
}

