/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZone;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryUpdateCmd
extends EPPUpdateCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryUpdateCmd.class);
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "registry:update";
    private EPPRegistryZone zone = null;

    public EPPRegistryUpdateCmd() {
    }

    public EPPRegistryUpdateCmd(String aTransId, EPPRegistryZone aZone) {
        super(aTransId);
        this.zone = aZone;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public String getKey() {
        if (this.zone != null && this.zone.getName() != null) {
            return this.getZone().getName().getName();
        }
        return null;
    }

    void validateState() throws EPPCodecException {
        if (this.zone == null) {
            throw new EPPCodecException("zone required attribute is not set");
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryUpdateCmd)) {
            cat.error("EPPRegistryUpdateCmd.equals(): " + aObject.getClass().getName() + " not EPPRegistryUpdateCmd instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPRegistryUpdateCmd.equals(): super class not equal");
            return false;
        }
        EPPRegistryUpdateCmd theComp = (EPPRegistryUpdateCmd)aObject;
        if (!EqualityUtil.equals(this.zone, theComp.zone)) {
            cat.error("EPPRegistryUpdateCmd.equals(): zone not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryUpdateCmd clone = (EPPRegistryUpdateCmd)super.clone();
        if (this.zone != null) {
            clone.zone = (EPPRegistryZone)this.zone.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRegistryUpdateCmd.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRegistryUpdateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.zone);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.zone = (EPPRegistryZone)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:zone", EPPRegistryZone.class);
    }

    public EPPRegistryZone getZone() {
        return this.zone;
    }

    public void setZone(EPPRegistryZone aZone) {
        this.zone = aZone;
    }
}

