/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryGracePeriod
extends EPPRegistryPeriodType {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryGracePeriod.class);
    public static final String ELM_LOCALNAME = "gracePeriod";
    public static final String ATTR_COMMAND = "command";
    protected String command = null;

    public EPPRegistryGracePeriod() {
    }

    public EPPRegistryGracePeriod(String aCommand, Integer aNumber, EPPRegistryPeriodType.Unit aUnit) {
        this.command = aCommand;
        this.number = aNumber;
        this.unit = aUnit;
    }

    public EPPRegistryGracePeriod(String command, int number, EPPRegistryPeriodType.Unit unit) {
        this(command, (Integer)number, unit);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = super.encode(aDocument);
        root.setAttribute(ATTR_COMMAND, this.command);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.command = aElement.getAttribute(ATTR_COMMAND);
    }

    @Override
    void validateState() throws EPPCodecException {
        super.validateState();
        if (this.command == null || this.command.trim().length() == 0) {
            throw new EPPCodecException(this.getRootName() + ": command is empty");
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryGracePeriod)) {
            return false;
        }
        EPPRegistryGracePeriod theComp = (EPPRegistryGracePeriod)aObject;
        if (!super.equals(aObject)) {
            return false;
        }
        if (!EqualityUtil.equals(this.command, theComp.command)) {
            cat.error("EPPRegistryGracePeriod.equals(): command not equal");
            return false;
        }
        return true;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    void extraValidate() throws EPPCodecException {
        int n = this.number;
        if (n <= 0) {
            throw new EPPCodecException(this.getRootName() + ": number should be greater than 0");
        }
        if (this.unit != EPPRegistryPeriodType.Unit.d && this.unit != EPPRegistryPeriodType.Unit.h && this.unit != EPPRegistryPeriodType.Unit.m) {
            throw new EPPCodecException(this.getRootName() + ": invalid unit. Valid values: d/h/m");
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }
}

