/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPDeleteCmd;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryZoneName;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDeleteCmd
extends EPPDeleteCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDeleteCmd.class);
    public static final String ELM_LOCALNAME = "delete";
    public static final String ELM_NAME = "registry:delete";
    private EPPRegistryZoneName name;

    public EPPRegistryDeleteCmd() {
        this.name = null;
    }

    public EPPRegistryDeleteCmd(String aTransId, String aName) {
        super(aTransId);
        this.setName(aName);
    }

    public EPPRegistryDeleteCmd(String aTransId, EPPRegistryZoneName aName) {
        super(aTransId);
        this.setName(aName);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public String getKey() {
        if (this.name != null) {
            return this.getName().getName();
        }
        return null;
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDeleteCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryDeleteCmd theComp = (EPPRegistryDeleteCmd)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error("EPPRegistryDeleteCmd.equals(): name not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDeleteCmd clone = (EPPRegistryDeleteCmd)super.clone();
        if (this.name != null) {
            clone.name = (EPPRegistryZoneName)this.name.clone();
        }
        return clone;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.name);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = (EPPRegistryZoneName)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "name", EPPRegistryZoneName.class);
    }
}

