/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPRegistryDefaultPeriodType
extends EPPRegistryPeriodType {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryDefaultPeriodType.class);
    public static final String ELM_LOCALNAME = "default";
    public static final String ELM_NAME = "registry:default";

    public EPPRegistryDefaultPeriodType() {
    }

    public EPPRegistryDefaultPeriodType(Integer aNumber, EPPRegistryPeriodType.Unit aUnit) {
        this.number = aNumber;
        this.unit = aUnit;
    }

    public EPPRegistryDefaultPeriodType(int aNumber, EPPRegistryPeriodType.Unit aUnit) {
        this();
        this.number = aNumber;
        this.unit = aUnit;
    }

    @Override
    void extraValidate() throws EPPCodecException {
        int theNumber = this.number;
        if (theNumber < 1 || theNumber > 99) {
            throw new EPPCodecException(this.getRootName() + ": number should be between 1 - 99.");
        }
        if (this.unit != EPPRegistryPeriodType.Unit.y && this.unit != EPPRegistryPeriodType.Unit.m) {
            throw new EPPCodecException(this.getRootName() + ": invalid unit. Valid values: y/m");
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    protected String getRootName() {
        return ELM_LOCALNAME;
    }
}

