/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryServicesExt;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryServices
implements EPPCodecComponent {
    private static final long serialVersionUID = 1632373332571396110L;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryServices.class);
    public static final String ELM_NAME = "registry:services";
    private List objURIs = new ArrayList();
    EPPRegistryServicesExt extension;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.objURIs == null || this.objURIs.size() == 0) {
            throw new EPPEncodeException("Invalid state on EPPRegistryServices.encode: objURIs is required.");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.objURIs);
        if (this.extension != null) {
            EPPUtil.encodeComp(aDocument, root, this.extension);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.objURIs = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:objURI", EPPRegistryObjURI.class);
        this.extension = (EPPRegistryServicesExt)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:svcExtension", EPPRegistryServicesExt.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryServices clone = (EPPRegistryServices)super.clone();
        if (this.objURIs != null) {
            clone.objURIs = (List)((ArrayList)this.objURIs).clone();
        }
        if (this.extension != null) {
            clone.extension = (EPPRegistryServicesExt)this.extension.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryServices)) {
            return false;
        }
        EPPRegistryServices theComp = (EPPRegistryServices)aObject;
        if (!(this.objURIs != null ? EPPUtil.equalLists(this.objURIs, theComp.objURIs) : theComp.objURIs == null || theComp.objURIs.size() == 0)) {
            cat.error("EPPRegistryServices.equals(): objURIs not equal");
            return false;
        }
        if (!(this.extension != null ? this.extension.equals(theComp.extension) : theComp.extension == null)) {
            cat.error("EPPRegistryServices.equals(): extension not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public List getObjURIs() {
        return this.objURIs;
    }

    public void setObjURIs(List objURIs) {
        this.objURIs = objURIs;
    }

    public void addObjURI(EPPRegistryObjURI uri) {
        if (this.objURIs == null) {
            this.objURIs = new ArrayList();
        }
        this.objURIs.add(uri);
    }

    public EPPRegistryServicesExt getExtension() {
        return this.extension;
    }

    public void setExtension(EPPRegistryServicesExt extension) {
        this.extension = extension;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    public static class EPPRegistryObjURI
    extends EPPRegistryURI {
        private static final long serialVersionUID = -4093552942649030852L;

        public EPPRegistryObjURI() {
        }

        public EPPRegistryObjURI(String uri, Boolean required) {
            super(uri, required);
        }

        @Override
        public String getRootName() {
            return "registry:objURI";
        }

        @Override
        public boolean equals(Object aObject) {
            return super.equals(aObject);
        }

        @Override
        public String getNamespace() {
            return "http://www.verisign.com/epp/registry-1.0";
        }
    }

    public static abstract class EPPRegistryURI
    implements EPPCodecComponent {
        private static final long serialVersionUID = 7553465772991675424L;
        public static final String ELM_OBJ_URI = "registry:objURI";
        public static final String ELM_EXT_URI = "registry:extURI";
        public static final String ATTR_REQUIRED = "required";
        private Boolean required = null;
        private String uri = null;

        public EPPRegistryURI() {
        }

        public EPPRegistryURI(String uri, Boolean required) {
            this.uri = uri;
            this.required = required;
        }

        public abstract String getRootName();

        @Override
        public Element encode(Document aDocument) throws EPPEncodeException {
            try {
                this.validateState();
            }
            catch (EPPCodecException e) {
                throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: " + e);
            }
            Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", this.getRootName());
            Text currVal = aDocument.createTextNode(this.uri);
            root.appendChild(currVal);
            root.setAttribute(ATTR_REQUIRED, this.required.toString());
            return root;
        }

        @Override
        public void decode(Element aElement) throws EPPDecodeException {
            this.uri = aElement.getFirstChild().getNodeValue();
            this.required = EPPUtil.decodeBooleanAttr(aElement, ATTR_REQUIRED);
        }

        private void validateState() throws EPPCodecException {
            if (this.uri == null || this.uri.trim().length() == 0) {
                throw new EPPCodecException("uri attribute is not set");
            }
            if (this.required == null) {
                throw new EPPCodecException("required attribute is not set");
            }
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return (EPPRegistryURI)super.clone();
        }

        public boolean equals(Object aObject) {
            if (!(aObject instanceof EPPRegistryURI)) {
                return false;
            }
            EPPRegistryURI theComp = (EPPRegistryURI)aObject;
            if (!(this.uri != null ? this.uri.equals(theComp.uri) : theComp.uri == null)) {
                cat.error(this.getClass().getName() + ".equals(): uri not equal");
                return false;
            }
            if (!(this.required != null ? this.required.booleanValue() == theComp.required.booleanValue() : theComp.required == null)) {
                cat.error(this.getClass().getName() + "EPPRegistryExtension.equals(): \"required\" not equal");
                return false;
            }
            return true;
        }

        public String toString() {
            return EPPUtil.toString(this);
        }

        public Boolean getRequired() {
            return this.required;
        }

        public void setRequired(Boolean required) {
            this.required = required;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }
}

