/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPRegistryInfoCmd
extends EPPInfoCmd {
    private static final long serialVersionUID = 7204018220215077843L;
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryInfoCmd.class);
    static final String ELM_NAME = "registry:info";
    private static final String ELM_REGISTRY_NAME = "registry:name";
    private static final String ELM_REGISTRY_ALL = "registry:all";
    private boolean all = false;
    private String name;

    public EPPRegistryInfoCmd() {
    }

    public EPPRegistryInfoCmd(String aTransId, String aName) {
        super(aTransId);
        this.name = aName;
        this.all = false;
    }

    public EPPRegistryInfoCmd(String aTransId, boolean all) {
        super(aTransId);
        this.name = null;
        this.all = all;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null && !this.all || this.name != null && this.all) {
            throw new EPPEncodeException("Name is required, unless \"all\" is set.");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute("xmlns:registry", "http://www.verisign.com/epp/registry-1.0");
        Element nameElm = null;
        if (!this.all) {
            nameElm = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
            Text nameVal = aDocument.createTextNode(this.name);
            nameElm.appendChild(nameVal);
        } else {
            nameElm = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_ALL);
        }
        root.appendChild(nameElm);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        this.all = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_ALL) != null;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryInfoCmd)) {
            cat.error("EPPRegistryInfoCmd.equals(): " + aObject.getClass().getName() + " not EPPRegistryInfoCmd instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPRegistryInfoCmd.equals(): super class not equal");
            return false;
        }
        EPPRegistryInfoCmd theComp = (EPPRegistryInfoCmd)aObject;
        if (this.all != theComp.all) {
            cat.error("EPPRegistryInfoCmd.equals(): \"all\" not equal");
            return false;
        }
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error("EPPRegistryInfoCmd.equals(): name not equal");
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }
}

