/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.persreg;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.persreg.EPPPersRegCreate;
import com.verisign.epp.codec.persreg.EPPPersRegCreateData;
import com.verisign.epp.codec.persreg.EPPPersRegInfoData;
import com.verisign.epp.codec.persreg.EPPPersRegRenewData;
import com.verisign.epp.codec.persreg.EPPPersRegTransferData;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EPPPersRegTst {
    private static long numIterations = 1L;
    private static boolean validate = true;
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static boolean _initLogging = true;

    @Test
    public void testPersRegInfo() {
        EPPCodecTst.printStart("testPersRegInfo");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        Vector<EPPEmailFwdStatus> emailStatuses = new Vector<EPPEmailFwdStatus>();
        emailStatuses.addElement(new EPPEmailFwdStatus("ok"));
        EPPEmailFwdInfoResp theEmailResponse = new EPPEmailFwdInfoResp(respTransId, "EXAMPLE1-VRSN", "john@doe.name", "jdoe@example.com", "ClientX", emailStatuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theEmailResponse.setResult(1000);
        theEmailResponse.addExtension(new EPPPersRegInfoData("ID:12345"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theEmailResponse);
        System.out.println(theStats);
        Vector<EPPDomainStatus> domainStatuses = new Vector<EPPDomainStatus>();
        domainStatuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theDomainResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", domainStatuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theDomainResponse.setResult(1000);
        theDomainResponse.addExtension(new EPPPersRegInfoData("ID:12345"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testPersRegInfo");
    }

    @Test
    public void testPersRegCreate() {
        EPPCodecTst.printStart("testPersRegCreate");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPEmailFwdCreateCmd theEmailCommand = new EPPEmailFwdCreateCmd("ABC-12345", "john@doe.name", "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theEmailCommand.addExtension(new EPPPersRegCreate("ID:12345"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theEmailCommand);
        System.out.println(theStats);
        EPPEmailFwdCreateResp theEmailResponse = new EPPEmailFwdCreateResp(respTransId, "john@doe.name", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theEmailResponse.setResult(1000);
        theEmailResponse.addExtension(new EPPPersRegCreateData(true));
        theStats = EPPCodecTst.testEncodeDecode(theEmailResponse);
        System.out.println(theStats);
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "john.doe.name", new EPPAuthInfo("2fooBAR"));
        theDomainCommand.addExtension(new EPPPersRegCreate("ID:12345"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPDomainCreateResp theDomainResponse = new EPPDomainCreateResp(respTransId, "john.doe.name", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theDomainResponse.setResult(1000);
        theDomainResponse.addExtension(new EPPPersRegCreateData(false));
        theStats = EPPCodecTst.testEncodeDecode(theDomainResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testPersRegCreate");
    }

    @Test
    public void testPersRegRenew() {
        EPPCodecTst.printStart("testPersRegRenew");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPEmailFwdRenewResp theEmailResponse = new EPPEmailFwdRenewResp(respTransId, "john@doe.name", new Date());
        theEmailResponse.setResult(1000);
        theEmailResponse.addExtension(new EPPPersRegRenewData(true));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theEmailResponse);
        System.out.println(theStats);
        EPPDomainRenewResp theDomainResponse = new EPPDomainRenewResp(respTransId, "john.doe.name", new Date());
        theDomainResponse.setResult(1000);
        theDomainResponse.addExtension(new EPPPersRegRenewData(false));
        theStats = EPPCodecTst.testEncodeDecode(theDomainResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testPersRegRenew");
    }

    @Test
    public void testPersRegTransfer() {
        EPPCodecTst.printStart("testPersRegTransfer");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPEmailFwdTransferResp theEmailResponse = new EPPEmailFwdTransferResp(respTransId, "john@doe.name");
        theEmailResponse.setResult(1000);
        theEmailResponse.setRequestClient("ClientX");
        theEmailResponse.setActionClient("ClientY");
        theEmailResponse.setTransferStatus("pending");
        theEmailResponse.setRequestDate(new Date());
        theEmailResponse.setActionDate(new Date());
        theEmailResponse.setExpirationDate(new Date());
        theEmailResponse.addExtension(new EPPPersRegTransferData(true));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theEmailResponse);
        System.out.println(theStats);
        EPPDomainTransferResp theDomainResponse = new EPPDomainTransferResp(respTransId, "john.doe.name");
        theDomainResponse.setResult(1000);
        theDomainResponse.setRequestClient("ClientX");
        theDomainResponse.setActionClient("ClientY");
        theDomainResponse.setTransferStatus("pending");
        theDomainResponse.setRequestDate(new Date());
        theDomainResponse.setActionDate(new Date());
        theDomainResponse.setExpirationDate(new Date());
        theDomainResponse.addExtension(new EPPPersRegTransferData(false));
        theStats = EPPCodecTst.testEncodeDecode(theDomainResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testPersRegTransfer");
    }

    @BeforeClass
    public static void beforeClass() {
        EPPCodecTst.initEnvironment();
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.emailFwd.EPPEmailFwdMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.persreg.EPPPersRegExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static void setValidate(boolean aValidate) {
        validate = aValidate;
    }

    public static void setFactory(DocumentBuilderFactory aFactory) {
        factory = aFactory;
    }
}

